/* VMS_LIB_CREATE_DIR.C -- 29-NOV-1998 Uwe Zessin
   Python interface to LIB$CREATE_DIR
*/


#include "python.h"

#include <descrip.h>		/* DSC$...   */
#include <lib$routines.h>	/* LIB$name  */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */

char vms_lib_create_dir__doc[] =
"status = vms_lib.create_dir (devdir_spec, [owner_uic], [protection-enable], \
[protection-value], [maximum-versions], [relative-volume-number])\n\
Create a Directory.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_create_dir (PyObject *self, PyObject *args)
{
	char			* at_devdir_spec;
	struct dsc$descriptor_s   r_devdir_spec;
	unsigned long		  l_devdir_spec_len;

	PyObject		* ar_owner_uic;
	unsigned long		  l_owner_uic;
	unsigned long		* al_owner_uic;

	PyObject		* ar_protection_enable;
	unsigned long		  l_protection_enable;
	unsigned short int	  w_protection_enable;
	unsigned short int	* aw_protection_enable;

	PyObject		* ar_protection_value;
	unsigned long		  l_protection_value;
	unsigned short int	  w_protection_value;
	unsigned short int	* aw_protection_value;

	PyObject		* ar_maximum_versions;
	unsigned long		  l_maximum_versions;
	unsigned short int	  w_maximum_versions;
	unsigned short int	* aw_maximum_versions;

	PyObject		* ar_relative_volume_number;
	unsigned long		  l_relative_volume_number;
	unsigned short int	  w_relative_volume_number;
	unsigned short int	* aw_relative_volume_number;

	unsigned long		  l_status;

	/* -------------------- */
	ar_owner_uic              = Py_None;
	ar_protection_enable      = Py_None;
	ar_protection_value       = Py_None;
	ar_maximum_versions       = Py_None;
	ar_relative_volume_number = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|OOOOO",
	    &at_devdir_spec, &l_devdir_spec_len,
	    &ar_owner_uic,
	    &ar_protection_enable,
	    &ar_protection_value,
	    &ar_maximum_versions,
	    &ar_relative_volume_number))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: device-directory-spec */
	if (l_devdir_spec_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 1: devdir_spec - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_devdir_spec.dsc$w_length  = l_devdir_spec_len;
	r_devdir_spec.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_devdir_spec.dsc$b_class   = DSC$K_CLASS_S;
	r_devdir_spec.dsc$a_pointer = at_devdir_spec;

	/* -------------------- */
	/* argument 2: owner-UIC */
	if (ar_owner_uic == Py_None)
	{
	    al_owner_uic = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_owner_uic))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: owner-uic - must be integer or None");
		return NULL;
	    }
	    l_owner_uic = PyInt_AsLong(ar_owner_uic);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_owner_uic = &l_owner_uic;
	}

	/* -------------------- */
	/* argument 3: protection-enable */
	if (ar_protection_enable == Py_None)
	{
	    aw_protection_enable = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_protection_enable))
	    {
		PyErr_SetString(PyExc_TypeError,
    "argument 3: protection-enable - must be positive 16-bit integer or None");
		return NULL;
	    }
	    l_protection_enable = PyInt_AsLong(ar_protection_enable);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_protection_enable > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
    "argument 3: protection-enable - must be positive 16-bit integer or None");
		return NULL;
	    }
            w_protection_enable  = l_protection_enable;
	    aw_protection_enable = &w_protection_enable;
	}

	/* -------------------- */
	/* argument 4: protection-value */
	if (ar_protection_value == Py_None)
	{
	    aw_protection_value = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_protection_value))
	    {
		PyErr_SetString(PyExc_TypeError,
    "argument 4: protection-value - must be positive 16-bit integer or None");
		return NULL;
	    }
	    l_protection_value = PyInt_AsLong(ar_protection_value);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_protection_value > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
    "argument 4: protection-value - must be positive 16-bit integer or None");
		return NULL;
	    }
	    w_protection_value  = l_protection_value;
	    aw_protection_value = &w_protection_value;
	}

	/* -------------------- */
	/* argument 5: maximum-versions */
	if (ar_maximum_versions == Py_None)
	{
	    aw_maximum_versions = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_maximum_versions))
	    {
		PyErr_SetString(PyExc_TypeError,
     "argument 5: maximum-versions - must be positive 16-bit integer or None");
		return NULL;
	    }
	    l_maximum_versions = PyInt_AsLong(ar_maximum_versions);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_maximum_versions > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
     "argument 5: maximum-versions - must be positive 16-bit integer or None");
		return NULL;
	    }
	    w_maximum_versions  = l_maximum_versions;
	    aw_maximum_versions = &w_maximum_versions;
	}

	/* -------------------- */
	/* argument 6: relative-volume-number */
	if (ar_relative_volume_number == Py_None)
	{
	    aw_relative_volume_number = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_relative_volume_number))
	    {
		PyErr_SetString(PyExc_TypeError,
"argument 6: relative-volume-number - must be positive 16-bit integer or None");
		return NULL;
	    }
	    l_relative_volume_number = PyInt_AsLong(ar_relative_volume_number);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_relative_volume_number > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
"argument 6: relative-volume-number - must be positive 16-bit integer or None");
		return NULL;
	    }
	    w_relative_volume_number  = l_relative_volume_number;
	    aw_relative_volume_number = &w_relative_volume_number;
	}

	/* -------------------- */
	l_status = lib$create_dir
		(&r_devdir_spec
		,al_owner_uic
		,aw_protection_enable
		,aw_protection_value
		,aw_maximum_versions
		,aw_relative_volume_number
		);

	/* -------------------- */
	/* this routine can return SS$_NORMAL + SS$_CREATED as success */
	/* you MUST check the return value yourself - no exception is raised! */
	return PyInt_FromLong(l_status);

} /* vms_lib_create_dir () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CREATE_DIR.C */
