/* VMS_LIB_CURRENCY.C -- 30-NOV-1998 Uwe Zessin
   Python interface to LIB$CURRENCY

   ??-???-???? ZE. -- created in VMS_LIB.C
   30-NOV-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_currency__doc[] =
"currency_string = vms_lib.currency ()\n\
Get System Currency Symbol.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_currency (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s r_currency_string;
	unsigned short int	w_resultant_length;

	unsigned long		l_status_lib;
	unsigned long		l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	/* no arguments taken */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$CURRENCY allocate the memory */
	r_currency_string.dsc$w_length  = 0;
	r_currency_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_currency_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_currency_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$currency (&r_currency_string, &w_resultant_length);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    ar_return = Py_BuildValue
		("s#", (w_resultant_length == 0)  ? /* empty string ? */
			(void*)&r_currency_string : /* non-NULL address */
			(void*)r_currency_string.dsc$a_pointer
		,(unsigned int)w_resultant_length);
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_currency_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_currency: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_currency () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
v = 255*'X'
dict = vms_lib.set_logical ('SYS$CURRENCY', v)
while (1):
  currency = vms_lib.currency()
# -while

-----

# -- check 2
import vms_lib
while (1):
  try:
    currency = vms_lib.currency('ERR')
  except:
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CURRENCY.C */
