/* VMS_LIB_CVT_FRMINTTIM.C -- 25-OCT-1998 Uwe Zessin
   Python interface to LIB$CVT_FROM_INTERNAL_TIME
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <libdef.h>		/* LIB$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

char vms_lib_cvt_frminttim__doc[] =
"resultant_time = vms_lib.cvt_from_internal_time (operation, input_time)\n\
Convert Internal Time to External Time.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_cvt_from_internal_time (PyObject *self, PyObject *args)
{
	unsigned long		  l_operation;

	PyObject		* ar_input_time;
	long			  q_input_time[2];
	long			* aq_input_time;

	unsigned long		  l_resultant_time;

	unsigned long		  l_status;

	/* -------------------- */
	ar_input_time = Py_None;	/* default, if omitted */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l|O", &l_operation, &ar_input_time))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 - operation */

	/* -------------------- */
	/* argument 2 - input-time */
	if (ar_input_time == Py_None)
	{
	    aq_input_time = 0;			/* omitted */
	}
	else
	{
	    if (!PyLong_Check(ar_input_time))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: input-time - must be long integer");
		return NULL;
	    }

	    l_status = vms__cvt_pylong2quad (ar_input_time, &q_input_time[0]);
	    if (l_status == -1)
	    {
		return NULL;		/* error string has been set */
	    }
	    aq_input_time = &q_input_time[0];
	}

	/* -------------------- */
	l_status = lib$cvt_from_internal_time
		(&l_operation
		,&l_resultant_time
		,aq_input_time		/* optional */
		);

	/* -------------------- */
	if (l_status == LIB$_NORMAL)
	{
	    return PyInt_FromLong(l_resultant_time);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_cvt_from_internal_time () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CVT_FRMINTTIM.C */
