/* VMS_LIB_CVTF_FRMINTTIM.C -- 24-OCT-1998 Uwe Zessin
   Python interface to LIB$CVTF_FROM_INTERNAL_TIME
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <libdef.h>		/* LIB$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

char vms_lib_cvtf_frminttim__doc[] =
"resultant_time = vms_lib.cvtf_from_internal_time (operation, input_time)\n\
Convert Internal Time to External Time (F-Floating-Point Value).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_cvtf_from_internal_time (PyObject *self, PyObject *args)
{
	unsigned long		  l_operation;

	PyObject		* ar_input_time;
	long			  q_input_time[2];

	float			  f_resultant_time;

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "lO", &l_operation, &ar_input_time))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 - operation */

	/* -------------------- */
	/* argument 2 - input-time */
	if (!PyLong_Check(ar_input_time))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 2: input-time - must be long integer");
	    return NULL;
	}

	/* convert Python long integer to binary quadword */
	l_status = vms__cvt_pylong2quad (ar_input_time, &q_input_time[0]);
	if (l_status == -1)
	{
	    return NULL;		/* error string has been set */
	}

	/* -------------------- *
	l_status = lib$cvtf_from_internal_time
		(&l_operation
		,&f_resultant_time
		,&q_input_time[0]
		);

	/* -------------------- *
	if (l_status == LIB$_NORMAL)
	{
	    return Py_BuildValue ("f", f_resultant_time);
	}

	/* -------------------- *
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_cvtf_from_internal_time () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CVTF_FRMINTTIM.C */
