/* VMS_LIB_CVTF_TOINTTIM.C -- 24-OCT-1998 Uwe Zessin
   Python interface to LIB$CVTF_TO_INTERNAL_TIME
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <libdef.h>		/* LIB$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------------------------------------------------- */

char vms_lib_cvtf_tointtim__doc[] =
"resultant_time = vms_lib.cvtf_to_internal_time (operation, input_time)\n\
Convert External Time to Internal Time (F-Floating-Point Value).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_cvtf_to_internal_time (PyObject *self, PyObject *args)
{
	unsigned long		  l_operation;

	float			  f_input_time;

	PyObject		* ar_resultant_time;
	long			  q_resultant_time[2];

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "lf", &l_operation, &f_input_time))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 - operation */

	/* -------------------- */
	/* argument 2 - input-time */

	/* -------------------- */
	l_status = lib$cvtf_to_internal_time
		(&l_operation
		,&f_input_time
		,&q_resultant_time[0]
		);

	/* -------------------- */
	if (l_status == LIB$_NORMAL)
	{
	    return vms__cvt_quad2pylong (&q_resultant_time[0]);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_cvtf_to_internal_time () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_CVTF_TOINTTIM.C */
