/* VMS_LIB_DATE_TIME.C -- 30-NOV-1998 Uwe Zessin
   Python interface to LIB$DATE_TIME

   ??-???-???? ZE. -- created in VMS_LIB.C
   01-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_date_time__doc[] =
"date_time_string = vms_lib.date_time ()\n\
Date and Time Returned as a String.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_date_time (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s   r_date_time_string;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	/* no arguments taken */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$DATE_TIME allocate the memory */
	r_date_time_string.dsc$w_length  = 0;
	r_date_time_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_date_time_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_date_time_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$date_time (&r_date_time_string);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	  ar_return = Py_BuildValue
	    ("s#", (r_date_time_string.dsc$w_length == 0) ? /* empty string? */
		   (void*)&r_date_time_string          : /* non-NULL address */
		   (void*)r_date_time_string.dsc$a_pointer
	    ,(unsigned int)r_date_time_string.dsc$w_length);
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_date_time_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_date_time: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_date_time () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
while (1):
  date_time = vms_lib.date_time()
# -while

-----

# -- check 2
import vms_lib
while (1):
  try:
    date_time = vms_lib.date_time('ERR')
  except:
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_DATE_TIME.C */
