/* VMS_LIB_DELETE_FILE.C -- 30-JAN-1999 Uwe Zessin
   Python interface to LIB$DELETE_FILE
*/


#include "python.h"
#include "vmsdef.h"
#include "vmsobj_fab.h"

#include <descrip.h>		/* DSC$...   */
#include <fab.h>
#include <libdef.h>		/* LIB$_name */
#include <lib$routines.h>	/* LIB$name  */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
/* Python callback routines */
static PyObject * vms_lib__ar_user_success_procedure;
static PyObject * vms_lib__ar_user_error_procedure;
static PyObject * vms_lib__ar_user_confirm_procedure;

/* ------------------------------------------------------------------------- */

char vms_lib_delete_file__doc[] =
"status, context, resultant-name = vms_lib.delete_file (\
filespec [,default-filespec] [,related-filespec] [,user-success-procedure]\
 [,user-error-procedure] [,user-confirm-procedure] [,user-specified-argument]\
 [,file-scan-context])\n\
Delete One or More Files.";

/* ------------------------------------------------------------------------- */

static unsigned long vms_lib__user_success_procedure
    (struct dsc$descriptor_s  * ar_filespec
    ,unsigned long		l_user_specified_argument
    )
{
	PyObject	* ar_py_argument;
	PyObject	* ar_py_user_specified_argument;
	PyObject	* ar_status;
	unsigned long	  l_status;

	/* -------------------- */
	if (l_user_specified_argument == 0)
	{
	    ar_py_user_specified_argument = Py_None;
	}
	else
	{
	    ar_py_user_specified_argument = (PyObject *)l_user_specified_argument;
	}

	/* -------------------- */
	ar_py_argument = Py_BuildValue ("(s#O)",
	    ar_filespec->dsc$a_pointer,
	    (unsigned int)ar_filespec->dsc$w_length,
	    ar_py_user_specified_argument);
	if (ar_py_argument == NULL)
	{
	    return SS$_ABORT;		/* assume error has been set up */
	}

	/* -------------------- */
	ar_status = PyObject_CallObject
		(vms_lib__ar_user_success_procedure,ar_py_argument);
	Py_DECREF(ar_py_argument);	/* drop this object */

	/* -------------------- */
	if (ar_status == NULL)
	{
	    return SS$_ABORT;		/* assume error has been set up */
	}
	if (ar_status == Py_None)
	{
	    return SS$_NORMAL;
	}
	if (!PyInt_Check(ar_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"user-success-routine must return integer or None");
	    return SS$_ABORT;
	}
	l_status = PyInt_AsLong(ar_status);
	if (PyErr_Occurred())
	{
	    return SS$_ABORT;
	}
	return l_status;	/* from user-success-routine */
} /* vms_lib__user_success_procedure () */

/* ---------------------------------------- */

static unsigned long vms_lib__user_error_procedure
    (struct dsc$descriptor_s  * ar_filespec
    ,unsigned long	      * l_rms_sts
    ,unsigned long	      * l_rms_stv
    ,long		      * l_error_source
    ,unsigned long		l_user_specified_argument
    )
{
	PyObject	* ar_py_argument;
	PyObject	* ar_py_user_specified_argument;
	PyObject	* ar_status;
	unsigned long	  l_status;

	/* -------------------- */
	if (l_user_specified_argument == 0)
	{
	    ar_py_user_specified_argument = Py_None;
	}
	else
	{
	    ar_py_user_specified_argument = (PyObject *)l_user_specified_argument;
	}

	/* -------------------- */
	ar_py_argument = Py_BuildValue ("(s#lllO)",
	    ar_filespec->dsc$a_pointer,
	    (unsigned int)ar_filespec->dsc$w_length,
	    * l_rms_sts,
	    * l_rms_stv,
	    * l_error_source,
	    ar_py_user_specified_argument);
	if (ar_py_argument == NULL)
	{
	    return SS$_ABORT;		/* assume error has been set up */
	}

	/* -------------------- */
	ar_status = PyObject_CallObject
		(vms_lib__ar_user_error_procedure,ar_py_argument);
	Py_DECREF(ar_py_argument);	/* drop this object */

	/* -------------------- */
	if (ar_status == NULL)
	{
	    return SS$_ABORT;		/* assume error has been set up */
	}
	if (ar_status == Py_None)
	{
	    return SS$_NORMAL;
	}
	if (!PyInt_Check(ar_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"user-error-routine must return integer or None");
	    return SS$_ABORT;
	}
	l_status = PyInt_AsLong(ar_status);
	if (PyErr_Occurred())
	{
	    return SS$_ABORT;
	}
	return l_status;	/* from user-error-routine */
} /* vms_lib__user_error_procedure () */

/* ---------------------------------------- */

static unsigned long vms_lib__user_confirm_procedure
    (struct dsc$descriptor_s  * ar_filespec
    ,struct FAB		      * ar_fab
    ,unsigned long		l_user_specified_argument
    )
{
	vmsobj_fab	* ar_py_fab;
	PyObject	* ar_py_argument;
	PyObject	* ar_py_user_specified_argument;
	PyObject	* ar_status;
	unsigned long	  l_status;

	/* -------------------- */
	ar_py_fab = vmsobj_fab_new (ar_fab);
	if (ar_py_fab == NULL)
	{
	    /* assume error has been set up */
	    return SS$_ABORT;		/* don't delete file */
	}

	/* -------------------- */
	if (l_user_specified_argument == 0)
	{
	    ar_py_user_specified_argument = Py_None;
	}
	else
	{
	    ar_py_user_specified_argument = (PyObject *)l_user_specified_argument;
	}

	/* -------------------- */
	ar_py_argument = Py_BuildValue ("(s#OO)",
	    ar_filespec->dsc$a_pointer,
	    (unsigned int)ar_filespec->dsc$w_length,
	    ar_py_fab,
	    ar_py_user_specified_argument);
	Py_DECREF(ar_py_fab);		/* FAB object is no longer needed */
	if (ar_py_argument == NULL)
	{
	    return SS$_ABORT;		/* don't delete file */
	}

	/* -------------------- */
	ar_status = PyObject_CallObject
		(vms_lib__ar_user_confirm_procedure,ar_py_argument);
	Py_DECREF(ar_py_argument);	/* drop this object */

	/* -------------------- */
	if (ar_status == NULL)
	{
	    /* assume error has been set up */
	    return SS$_ABORT;		/* don't delete file */
	}
	if (ar_status == Py_None)
	{
	    return SS$_ABORT;	/* don't delete file */
	}
	if (!PyInt_Check(ar_status))
	{
	    PyErr_SetString(PyExc_TypeError,
		"user-confirm-routine must return integer or None");
	    return SS$_ABORT;	/* don't delete file */
	}
	l_status = PyInt_AsLong(ar_status);
	if (PyErr_Occurred())
	{
	    return SS$_ABORT;	/* don't delete file */
	}
	return l_status;	/* from user-confirm-routine */
} /* vms_lib__user_confirm_procedure () */

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_delete_file (PyObject *self, PyObject *args)
{
	char			* at_filespec;
	struct dsc$descriptor_s   r_filespec;
	unsigned long		  l_filespec_len;

	char			* at_default_filespec;
	struct dsc$descriptor_s   r_default_filespec;
	struct dsc$descriptor_s * ar_default_filespec;
	unsigned long		  l_default_filespec_len;

	char			* at_related_filespec;
	struct dsc$descriptor_s   r_related_filespec;
	struct dsc$descriptor_s * ar_related_filespec;
	unsigned long		  l_related_filespec_len;

	PyObject		* ar_user_success_procedure;
	unsigned long		* al_user_success_procedure;

	PyObject		* ar_user_error_procedure;
	unsigned long		* al_user_error_procedure;

	PyObject		* ar_user_confirm_procedure;
	unsigned long		* al_user_confirm_procedure;

	PyObject		* ar_user_specified_argument;
	unsigned long		  l_user_specified_argument; /* BY-VALUE */

	struct dsc$descriptor_s   r_resultant_name;

	PyObject		* ar_file_scan_context;
	unsigned long		  l_file_scan_context;
	unsigned long		* al_file_scan_context;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	at_default_filespec        = NULL;
	at_related_filespec        = NULL;
	ar_user_success_procedure  = Py_None;
	ar_user_error_procedure    = Py_None;
	ar_user_confirm_procedure  = Py_None;
	ar_user_specified_argument = Py_None;
	ar_file_scan_context       = Py_None;
	l_file_scan_context = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|z#z#OOOOO",
	    &at_filespec,                &l_filespec_len,
	    &at_default_filespec,        &l_default_filespec_len,
	    &at_related_filespec,        &l_related_filespec_len,
	    &ar_user_success_procedure,
	    &ar_user_error_procedure,
	    &ar_user_confirm_procedure,
	    &ar_user_specified_argument,
	    &ar_file_scan_context))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: filespec */
	if (l_filespec_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 1: filespec - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_filespec.dsc$w_length  = l_filespec_len;
	r_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_filespec.dsc$b_class   = DSC$K_CLASS_S;
	r_filespec.dsc$a_pointer = at_filespec;

	/* -------------------- */
	/* argument 2: default_filespec */
	if (at_default_filespec == NULL)
	{
	    ar_default_filespec = 0;
	}
	else
	{
	    if (l_default_filespec_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
     "argument 2: default_filespec - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_default_filespec.dsc$w_length  = l_default_filespec_len;
	    r_default_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_default_filespec.dsc$b_class   = DSC$K_CLASS_S;
	    r_default_filespec.dsc$a_pointer = at_default_filespec;
	    ar_default_filespec = &r_default_filespec;
	}

	/* -------------------- */
	/* argument 3: related_filespec */
	if (at_related_filespec == NULL)
	{
	    ar_related_filespec = 0;
	}
	else
	{
	    if (l_related_filespec_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
     "argument 3: related_filespec - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_related_filespec.dsc$w_length  = l_related_filespec_len;
	    r_related_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_related_filespec.dsc$b_class   = DSC$K_CLASS_S;
	    r_related_filespec.dsc$a_pointer = at_related_filespec;
	    ar_related_filespec = &r_related_filespec;
	}

	/* -------------------- */
	/* argument 4: user_success_procedure */
	if (ar_user_success_procedure == Py_None)
	{
	    al_user_success_procedure = 0;
	    vms_lib__ar_user_success_procedure = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_user_success_procedure))
	    {
		PyErr_SetString(PyExc_TypeError,
	      "argument 4: user_success_procedure - must be function or None");
		return NULL;
	    }
	    /* store object */
	    vms_lib__ar_user_success_procedure = ar_user_success_procedure;
	    al_user_success_procedure =
		(unsigned long *)&vms_lib__user_success_procedure;
	}

	/* -------------------- */
	/* argument 5: user_error_procedure */
	if (ar_user_error_procedure == Py_None)
	{
	    al_user_error_procedure = 0;
	    vms_lib__ar_user_error_procedure = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_user_error_procedure))
	    {
		PyErr_SetString(PyExc_TypeError,
		"argument 5: user_error_procedure - must be function or None");
		return NULL;
	    }
	    /* store object */
	    vms_lib__ar_user_error_procedure = ar_user_error_procedure;
	    al_user_error_procedure =
		(unsigned long *)&vms_lib__user_error_procedure;
	}

	/* -------------------- */
	/* argument 6: user_confirm_procedure */
	if (ar_user_confirm_procedure == Py_None)
	{
	    al_user_confirm_procedure = 0;
	    vms_lib__ar_user_confirm_procedure = NULL;
	}
	else
	{
	    /* argument must be a Python function object */
	    if (!PyFunction_Check (ar_user_confirm_procedure))
	    {
		PyErr_SetString(PyExc_TypeError,
	      "argument 6: user_confirm_procedure - must be function or None");
		return NULL;
	    }
	    /* store object */
	    vms_lib__ar_user_confirm_procedure = ar_user_confirm_procedure;
	    al_user_confirm_procedure =
		(unsigned long *)&vms_lib__user_confirm_procedure;
	}

	/* -------------------- */
	/* argument 7: user_specified_argument */
	if (ar_user_specified_argument == Py_None)
	{
	    l_user_specified_argument = 0;	/* BY-VALUE */
	}
	else
	{
	    l_user_specified_argument = (long)ar_user_specified_argument;
	}

	/* -------------------- */
	/* argument 8: file_scan_context */
	if (ar_file_scan_context == Py_None)
	{
	    al_file_scan_context = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_file_scan_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 8: file_scan_context - must be integer or None");
		return NULL;
	    }
	    l_file_scan_context = PyInt_AsLong(ar_file_scan_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_file_scan_context = &l_file_scan_context;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$DELETE_FILE allocate the memory */
	r_resultant_name.dsc$w_length  = 0;
	r_resultant_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_name.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_name.dsc$a_pointer = 0;

	/* -------------------- */
	Py_XINCREF(vms_lib__ar_user_success_procedure);
	Py_XINCREF(vms_lib__ar_user_error_procedure);
	Py_XINCREF(vms_lib__ar_user_confirm_procedure);

	/* -------------------- */
	l_status_lib = lib$delete_file
		(&r_filespec
		,ar_default_filespec
		,ar_related_filespec
		,al_user_success_procedure
		,al_user_error_procedure
		,al_user_confirm_procedure
		,l_user_specified_argument	/* BY-VALUE */
		,&r_resultant_name
		,al_file_scan_context
		);

	/* -------------------- */
	/* release Python function objects */
	Py_XDECREF(vms_lib__ar_user_success_procedure);
	Py_XDECREF(vms_lib__ar_user_error_procedure);
	Py_XDECREF(vms_lib__ar_user_confirm_procedure);

	/* -------------------- */
	/* error from a user-routine? */
	if (PyErr_Occurred())
	{
	    (void) PyErr_Print();	/* print this error */
	    PyErr_SetString(PyExc_SystemError, "error in user-routine");

	    /* deallocate memory of dynamic string descriptor */
	    l_status_free = lib$sfree1_dd (&r_resultant_name);
	    if (l_status_free != SS$_NORMAL)
	    {
		(void) PyErr_Print();
		PyErr_SetString(PyExc_SystemError,
		    "vms_lib_delete_file: LIB$SFREE1_DD() failed");
		(void) PyErr_Print();
		return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_free);
	    }
	    return NULL;
	}

	/* -------------------- */
	/* this routine can return SS$_NORMAL +  LIB$_ERRROUCAL as success */
	/* you MUST check the return value yourself - no exception is raised! */
	if ((l_status_lib == SS$_NORMAL) || (l_status_lib == LIB$_ERRROUCAL))
	{
	    PyObject	* ar_strobj;

	    ar_strobj = Py_BuildValue
		("z#", (r_resultant_name.dsc$w_length == 0) ? /* empty string?*/
		(void*)&r_resultant_name	 : /* non-NULL address */
		(void*)r_resultant_name.dsc$a_pointer
		,(unsigned int)r_resultant_name.dsc$w_length);
	    if (ar_strobj != NULL)
	    {
		ar_return = Py_BuildValue ("llO",
			l_status_lib, l_file_scan_context, ar_strobj);
		Py_DECREF(ar_strobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_name);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_delete_file: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free; /* fail anyway */
	        Py_XDECREF(ar_return);
		ar_return = NULL;
	    }
	}

	/* -------------------- */
	if ((l_status_lib == SS$_NORMAL) || (l_status_lib == LIB$_ERRROUCAL))
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_delete_file () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_DELETE_FILE.C */
