/* VMS_LIB_FID_TO_NAME.C -- 02-DEC-1998 Uwe Zessin
   Python interface to LIB$FID_TO_NAME

   09-JAN-1998 ZE. -- created in VMS_LIB.C
   02-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
   23-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/


#include "python.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
static char vms_lib_f2n_arg2_t3i [] =
	"argument 2: file-id - must be a tuple of 3 16-bit integers";
static char vms_lib_f2n_arg2_tni [] =
	"argument 2: file-id - tuple-element:%d is not a 16-bit integer";

static char vms_lib_f2n_arg3_t3i [] =
	"argument 3: directory-id - must be a tuple of 3 16-bit integers";
static char vms_lib_f2n_arg3_tni [] =
	"argument 3: directory-id - tuple-element:%d is not a 16-bit integer";

/* ------------------------------------------------------------------------- */

char vms_lib_fid_to_name__doc[] =
"status, acp_status, filespec = vms_lib.fid_to_name (device_name, \
file_id [,directory_id])\n\
Convert Device and File ID to File Specification.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_fid_to_name (PyObject *self, PyObject *args)
{
	char			* at_device_name;
	struct dsc$descriptor_s   r_device_name;
	unsigned long		  l_device_name_len;

	PyObject		* ar_file_id;
	unsigned short int	  aw_file_id[3];

	unsigned long		  l_tuple_size;
	unsigned long		  l_tuple_index;
	PyObject		* ar_tuple_element;
	unsigned long		  l_tuple_element;

	struct dsc$descriptor_s   r_filespec;
	unsigned short int	  w_filespec_length;
	PyObject		* ar_filespec;

	PyObject		* ar_directory_id;
	unsigned short int	  aw_directory_id[3];
	unsigned short int	* aaw_directory_id;

	unsigned long		  l_acp_status;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	ar_directory_id = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#O|O",
	    &at_device_name, &l_device_name_len,
	    &ar_file_id,
	    &ar_directory_id))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: device-name */
	if (l_device_name_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 1: device-name - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_device_name.dsc$w_length  = l_device_name_len;
	r_device_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_device_name.dsc$b_class   = DSC$K_CLASS_S;
	r_device_name.dsc$a_pointer = at_device_name;

	/* -------------------- */
	/* argument 2: file-id */
	if (!PyTuple_Check(ar_file_id))
	{
	    PyErr_SetString(PyExc_TypeError, vms_lib_f2n_arg2_t3i);
	    return NULL;
	}

	l_tuple_size = PyTuple_Size(ar_file_id);
	if (l_tuple_size != 3)
	{
	    PyErr_SetString(PyExc_TypeError, vms_lib_f2n_arg2_t3i);
	    return NULL;
	}

	for (l_tuple_index = 0; l_tuple_index < 3; l_tuple_index++)
	{
	    ar_tuple_element = PyTuple_GetItem(ar_file_id, l_tuple_index);
	    if (ar_tuple_element == NULL)
	    {
		return NULL;
	    }
	    if (!PyInt_Check(ar_tuple_element))
	    {
		return PyErr_Format(PyExc_TypeError, vms_lib_f2n_arg2_tni,
					l_tuple_index);
	    }

	    l_tuple_element = PyInt_AsLong(ar_tuple_element);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_tuple_element > 65535)
	    {
		return PyErr_Format(PyExc_TypeError, vms_lib_f2n_arg2_tni,
					l_tuple_index);
	    }

	    aw_file_id[l_tuple_index] = l_tuple_element;
	}

	/* -------------------- */
	/* argument 3: directory-id */
	if (ar_directory_id == Py_None)
	{
	    aaw_directory_id = 0;		/* omitted */
	}
	else
	{
	  if (!PyTuple_Check(ar_directory_id))
	  {
	    PyErr_SetString(PyExc_TypeError, vms_lib_f2n_arg3_t3i);
	    return NULL;
	  }

	  l_tuple_size = PyTuple_Size(ar_directory_id);
	  if (l_tuple_size != 3)
	  {
	    PyErr_SetString(PyExc_TypeError, vms_lib_f2n_arg3_t3i);
	    return NULL;
	  }

	  for (l_tuple_index = 0; l_tuple_index < 3; l_tuple_index++)
	  {
	    ar_tuple_element = PyTuple_GetItem(ar_directory_id, l_tuple_index);
	    if (ar_tuple_element == NULL)
	    {
		return NULL;
	    }
	    if (!PyInt_Check(ar_tuple_element))
	    {
		return PyErr_Format(PyExc_TypeError, vms_lib_f2n_arg3_tni,
					l_tuple_index);
	    }

	    l_tuple_element = PyInt_AsLong(ar_tuple_element);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_tuple_element > 65535)
	    {
		return PyErr_Format(PyExc_TypeError, vms_lib_f2n_arg3_tni,
					l_tuple_index);
	    }

	    aw_directory_id[l_tuple_index] = l_tuple_element;
	  }
          aaw_directory_id = &aw_directory_id[0];
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$FID_TO_NAME allocate the memory */
	r_filespec.dsc$w_length  = 0;
	r_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_filespec.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_filespec.dsc$a_pointer = 0;

	w_filespec_length = 0;

	/* -------------------- */
	l_status_lib = lib$fid_to_name
		(&r_device_name
		,&aw_file_id[0]
		,&r_filespec
		,&w_filespec_length
		,aaw_directory_id
		,&l_acp_status
		);

	/* -------------------- */
	/* the documentation of OpenVMS VAX V6.1 seems wrong - */
	/*  lib$find_file returns SS$_NORMAL instead LIB$_NORMAL */
	if ((l_status_lib == LIB$_NORMAL) ||
	    (l_status_lib == SS$_NORMAL)    )
	{
	    ar_filespec = Py_BuildValue
		("s#", (w_filespec_length == 0) ? /* empty string? */
		(void*)&r_filespec		: /* non-NULL address */
		(void*)r_filespec.dsc$a_pointer
		,(unsigned int)w_filespec_length);
	}
	else
	{
	    ar_filespec = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_filespec);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_fid_to_name: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_filespec);
		ar_filespec = NULL;
	    }
	}

	/* -------------------- */
	/* either RTL error or Py_BuildValue() error */
	if (ar_filespec == NULL)
	{
	    ar_filespec = Py_None;
	    Py_INCREF(ar_filespec);
	}

	/* -------------------- */
	ar_return = Py_BuildValue ("llO",
		l_status_lib, l_acp_status, ar_filespec);
	Py_XDECREF (ar_filespec);

	return ar_return;

} /* vms_lib_fid_to_name () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
while (1):
  status, acp_status, filespec = vms_lib.fid_to_name \
    ('SYS$SYSDEVICE:', (4,4,0)) # a valid FID
# -while

-----

# -- check 2
import vms_lib
while (1):
  status, acp_status, filespec = vms_lib.fid_to_name \
    ('SYS$SYSDEVICE:', (4,5,0)) # an invalid FID
# -while

-----

# -- check 3
import vms_lib
while (1):
  try:
    status, acp_status, filespec = vms_lib.fid_to_name \
      ('SYS$SYSDEVICE:', 'X') # an invalid argument
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_FID_TO_NAME.C */
