/* VMS_LIB_FORMAT_DATE_TIME.C -- 23-JUL-1999 Uwe Zessin
   Python interface to LIB$FORMAT_DATE_TIME
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

/* input a Python long integer - output a binary quadword */
long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

char vms_lib_format_date_time__doc[] =
"status, context, date_string = vms_lib.format_date_time\
 ([date], [user-context], flags)\n\
Format Date and/or Time.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_format_date_time (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s   r_date_string;
	unsigned short int 	  w_date_length;

	PyObject		* ar_date;
	long			  q_date[2];
	long			* aq_date;

	PyObject		* ar_user_context;
	unsigned long		  l_user_context;
	unsigned long		* al_user_context;

	PyObject		* ar_flags;
	unsigned long		  l_flags;
	unsigned long		* al_flags;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	ar_date         = Py_None;
	ar_user_context = Py_None;
	l_user_context  = 0;
	ar_flags        = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|OOO",
	    &ar_date,
	    &ar_user_context,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: date */
	if (ar_date == Py_None)
	{
	    aq_date = 0;		/* omitted */
	}
	else
	{
	    if (!PyLong_Check(ar_date))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: date - must be long integer");
		return NULL;
	    }
	    /* convert Python long integer to binary quadword */
	    l_status_lib = vms__cvt_pylong2quad (ar_date, &q_date[0]);
	    if (l_status_lib == -1)
	    {
		return NULL;		/* error string has been set */
	    }
	    aq_date = &q_date[0];
	}

	/* -------------------- */
	/* argument 2: user-context */
	if (ar_user_context == Py_None)
	{
	    al_user_context = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_user_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: user-context - must be integer or None");
		return NULL;
	    }
	    l_user_context = PyInt_AsLong(ar_user_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_user_context = &l_user_context;
	}

	/* -------------------- */
	/* argument 3: flags */
	if (ar_flags == Py_None)
	{
	    al_flags = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_flags = &l_flags;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$FORMAT_DATE_TIME allocate the memory */
	r_date_string.dsc$w_length  = 0;
	r_date_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_date_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_date_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$format_date_time
		(&r_date_string
		,aq_date
		,al_user_context
		,&w_date_length
		,al_flags
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    PyObject	* ar_strobj;

	    ar_strobj = Py_BuildValue
		("s#", (w_date_length == 0) ? /* empty string? */
		(void*)&r_date_string	 : /* non-NULL address */
		(void*)r_date_string.dsc$a_pointer
		,(unsigned int)w_date_length);
	    if (ar_strobj != NULL)
	    {
		if (al_user_context == 0)
		{
		    ar_return = Py_BuildValue ("lOO",
				l_status_lib, Py_None, ar_strobj);
		}
		else
		{
		    ar_return = Py_BuildValue ("llO",
				l_status_lib, l_user_context, ar_strobj);
		}
		Py_DECREF(ar_strobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_date_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_format_date_time: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free; /* fail anyway */
	        Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_format_date_time () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_FORMAT_DATE_TIME.C */
