/* VMS_LIB_FORMAT_SOGW_PROT.C -- 12-AUG-1999 Uwe Zessin
   Python interface to LIB$FORMAT_SOGW_PROT()
*/

#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"
#include "vmsobj__ownership_names.h"

#include <descrip.h>		/* DSC$_name	 */
#include <lib$routines.h>	/* LIB$name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* #ifndef __ALPHA		/* lib$format_sogw_prot defined in Alpha/DEC C V5.2 */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long lib$format_sogw_prot(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
/* #endif /* __ALPHA */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;	/* in VMS_LIB.C */
/* ------------------------------------------------------------------------- */

char vms_lib_format_sogw_prot__doc[] =
"protection-string = vms_lib.format_sogw_prot (\
protection-mask, [access-names], [ownership-names], [ownership-separator],\
 [list-separator])\n\
Translate a protection mask into a formatted string.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_format_sogw_prot (PyObject *self, PyObject *args)
{
	unsigned long		l_protection_mask;
	unsigned short int	w_protection_mask;

	PyObject		* ar_accnam;
	long			* aq_access_names;

	PyObject		* ar_ownshp;
	long			* aq_ownership_names;

	char			* at_ownership_separator;
	struct dsc$descriptor_s   r_ownership_separator;
	struct dsc$descriptor_s * ar_ownership_separator;
	unsigned long		  l_ownership_separator_len;

	char			* at_list_separator;
	struct dsc$descriptor_s   r_list_separator;
	struct dsc$descriptor_s * ar_list_separator;
	unsigned long		  l_list_separator_len;

	char			* at_protection_string;
	struct dsc$descriptor_s   r_protection_string;
	unsigned short int	  w_protection_length;

	PyObject		* ar_return;	/* output */

	unsigned long		  l_status;

	/* -------------------- */
	ar_accnam  = Py_None;
	ar_ownshp  = Py_None;
	at_ownership_separator = NULL; l_ownership_separator_len = 0;
	at_list_separator      = NULL; l_list_separator_len      = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "i|OOz#z#",
	    &l_protection_mask,
	    &ar_accnam,
	    &ar_ownshp,
	    &at_ownership_separator, &l_ownership_separator_len,
	    &at_list_separator,      &l_list_separator_len
	    ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: protection_mask - done by PyArg_ParseTuple() */
	w_protection_mask = l_protection_mask;

	/* -------------------- */
	/* argument 2: access_names */
	if (ar_accnam == Py_None)
	{
	    aq_access_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__access_names_Check(ar_accnam))
	    {
		PyErr_SetString(PyExc_TypeError,
	    "argument 2: access_names - must be vmsobj__access_names or None");
		return NULL;
	    }
	    aq_access_names =
			((vmsobj__access_names *) ar_accnam)->aq_access_names;
	}

	/* -------------------- */
	/* argument 3: ownership_names */
	if (ar_ownshp == Py_None)
	{
	    aq_ownership_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__ownership_names_Check(ar_ownshp))
	    {
		PyErr_SetString(PyExc_TypeError,
      "argument 3: ownership_names - must be vmsobj__ownership_names or None");
		return NULL;
	    }
	    aq_ownership_names =
		   ((vmsobj__ownership_names *) ar_ownshp)->aq_ownership_names;
	}

	/* -------------------- */
	/* argument 4: ownership_separator */
	if (at_ownership_separator == NULL)
	{
	    ar_ownership_separator = 0;		/* omitted */
	}
	else
	{
	    if (l_ownership_separator_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
  "argument 4: ownership_separator - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_ownership_separator.dsc$w_length  = l_ownership_separator_len;
	    r_ownership_separator.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_ownership_separator.dsc$b_class   = DSC$K_CLASS_S;
	    r_ownership_separator.dsc$a_pointer = at_ownership_separator;
	    ar_ownership_separator = &r_ownership_separator;
	}

	/* -------------------- */
	/* argument 5: list_separator */
	if (at_list_separator == NULL)
	{
	    ar_list_separator = 0;		/* omitted */
	}
	else
	{
	    if (l_list_separator_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
       "argument 5: list_separator - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_list_separator.dsc$w_length  = l_list_separator_len;
	    r_list_separator.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_list_separator.dsc$b_class   = DSC$K_CLASS_S;
	    r_list_separator.dsc$a_pointer = at_list_separator;
	    ar_list_separator = &r_list_separator;
	}

	/* -------------------- */
	/* let LIB$FORMAT_SOGW_PROT() allocate memory */
	r_protection_string.dsc$w_length  = 0;
	r_protection_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_protection_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S ! */
	r_protection_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status = lib$format_sogw_prot
			(&w_protection_mask
			,aq_access_names
			,aq_ownership_names
			,ar_ownership_separator
			,ar_list_separator
			,&r_protection_string
			,&w_protection_length
			);

	/* -------------------- */
	/* help debugging: DBG> examine/ascid */
/*	r_protection_string.dsc$w_length = w_acllen;	*/

	/* -------------------- */
	/* return protection string */
#ifndef STR$_TRU
#define STR$_TRU 2392576
#endif
	if ( (l_status == SS$_NORMAL) || (l_status == STR$_TRU) )
	{
	    ar_return = Py_BuildValue ("ls#", l_status,
			r_protection_string.dsc$a_pointer,
			(unsigned int)r_protection_string.dsc$w_length);

	    lib$sfree1_dd (&r_protection_string);

	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_format_sogw_prot () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_FORMAT_SOGW_PROT.C */
