/* VMS_LIB_FREE_DATE_TIME_CONTEXT.C -- 23-JUL-1999 Uwe Zessin
   Python interface to LIB$FREE_DATE_TIME_CONTEXT

*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_free_date_time_ctx__doc[] =
"context = vms_lib.free_date_time_context (user-context)\n\
Free the Context Area Used when Formatting\
 Dates and Times for Input or Output.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_free_date_time_context (PyObject *self, PyObject *args)
{
	PyObject		* ar_user_context;
	unsigned long		  l_user_context;
	unsigned long		* al_user_context;

	unsigned long		  l_status;

	/* -------------------- */
	ar_user_context = Py_None;
	l_user_context  = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|O", &ar_user_context ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user-context */
	if (ar_user_context == Py_None)
	{
	    al_user_context = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_user_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: user_context - must be integer or None");
		return NULL;
	    }
	    l_user_context = PyInt_AsLong(ar_user_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_user_context = &l_user_context;
	}

	/* -------------------- */
	l_status = lib$free_date_time_context (al_user_context);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    if (al_user_context == 0)
	    {
		Py_INCREF (Py_None);
		return Py_None;
	    }
	    else
	    {
		return Py_BuildValue ("l", l_user_context);
	    }
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_free_date_time_context () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_FREE_DATE_TIME_CONTEXT.C */
