/* VMS_LIB_GET_ACCNAM.C -- 28-JUN-1999 Uwe Zessin
   Python interface to LIB$GET_ACCNAM
*/


#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
/* ----- */
#ifndef __ALPHA		/* defined in Alpha/DEC C V5.2 ? */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long lib$get_accnam(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
#endif /* __ALPHA */
#include <lib$routines.h>	/* LIB$name */
/* ----- */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;	/* in VMS_LIB.C */
/* ------------------------------------------------------------------------- */

char vms_lib_get_accnam__doc[] =
"accnam = vms_lib.get_accnam ([clsnam] [,objnam])\n\
Get Access Name Table for Protected Object Class (by Name).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_accnam (PyObject *self, PyObject *args)
{
	char			* at_clsnam;
	struct dsc$descriptor_s   r_clsnam;
	struct dsc$descriptor_s * ar_clsnam;
	unsigned long		  l_clsnam_len;

	char			* at_objnam;
	struct dsc$descriptor_s   r_objnam;
	struct dsc$descriptor_s * ar_objnam;
	unsigned long		  l_objnam_len;

	long			* aq_access_names; /* array of DESC. */

	unsigned long		  l_status;

	/* -------------------- */
	at_clsnam = NULL; l_clsnam_len = 0;
	at_objnam = NULL; l_objnam_len = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|z#z#",
	    &at_clsnam, &l_clsnam_len,
	    &at_objnam, &l_objnam_len  ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: objnam */
	if (at_clsnam == NULL)
	{
	    ar_clsnam = 0;		/* omitted */
	}
	else
	{
	    if (l_clsnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 1: clsnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_clsnam.dsc$w_length  = l_clsnam_len;
	    r_clsnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_clsnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_clsnam.dsc$a_pointer = at_clsnam;
	    ar_clsnam = &r_clsnam;
	}

	/* -------------------- */
	/* argument 2: objnam */
	if (at_objnam == NULL)
	{
	    ar_objnam = 0;		/* omitted */
	}
	else
	{
	    if (l_objnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 2: objnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_objnam.dsc$w_length  = l_objnam_len;
	    r_objnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_objnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_objnam.dsc$a_pointer = at_objnam;
	    ar_objnam = &r_objnam;
	}

	/* -------------------- */
	l_status = lib$get_accnam
			(ar_clsnam
			,ar_objnam
			,&aq_access_names
			);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    /* create a new ACCESS_NAMES object */
	    /* 0 = access names are not separately allocated */
	    return (PyObject *) vmsobj__access_names_new (aq_access_names, 0);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_get_accnam () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_ACCNAM.C */
