/* VMS_LIB_GET_ACCNAM_BY_CONTEXT.C -- 19-JUL-1999 Uwe Zessin
   Python interface to LIB$GET_ACCNAM_BY_CONTEXT
*/


#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
/* ----- */
#ifndef __ALPHA		/* defined in Alpha/DEC C V5.2 ? */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long lib$get_accnam_by_context(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
#endif /* __ALPHA */
#include <lib$routines.h>	/* LIB$name */
/* ----- */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;	/* in VMS_LIB.C */
/* ------------------------------------------------------------------------- */

char vms_lib_get_accnam_by_ctx__doc[] =
"accnam = vms_lib.get_accnam_by_context (contxt)\n\
Get Access Name Table for Protected Object Class (by Context).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_accnam_by_context (PyObject *self, PyObject *args)
{
	unsigned long		  l_contxt;

	long			* aq_access_names; /* array of DESC. */

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l", &l_contxt ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: contxt */
	/* (completely done by PyArg_ParseTuple() ) */

	/* -------------------- */
	l_status = lib$get_accnam_by_context
			(&l_contxt
			,&aq_access_names
			);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    /* create a new ACCESS_NAMES object */
	    /* 0 = access names are not separately allocated */
	    return (PyObject *) vmsobj__access_names_new (aq_access_names, 0);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_get_accnam_by_context () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_ACCNAM_BY_CONTEXT.C */
