/* VMS_LIB_GET_COMMON.C -- 11-DEC-1998 Uwe Zessin
   Python interface to LIB$GET_COMMON

   07-NOV-1997 ZE. -- created in VMS_LIB.C
   11-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_get_common__doc[] =
"resultant_string = vms_lib.get_common ()\n\
Get String from Common.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_common (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s   r_source_string;
	unsigned short int 	  w_resultant_length;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;
	PyObject		* ar_return;

	/* -------------------- */
	/* no input argument */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$GET_COMMON allocate the memory */
	r_source_string.dsc$w_length  = 0;
	r_source_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_source_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_source_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$get_common (&r_source_string, &w_resultant_length);

	/* -------------------- */
	/* Warning - string truncation is considered an error, too */
	/* this indicates a programmer error or a change in VMS */
	if (l_status_lib == SS$_NORMAL)
	{
	    ar_return = Py_BuildValue
		("s#", (w_resultant_length == 0) ? /* empty string? */
		(void*)&r_source_string		 : /* non-NULL address */
		(void*)r_source_string.dsc$a_pointer
		,(unsigned int)w_resultant_length);
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_source_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
	    "vms_lib_get_common: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}
	else
	{
	    Py_XDECREF(ar_return);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_get_common () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
data = 252*'*'
vms_lib.put_common(data)
while (1):
  data_from_common = vms_lib.get_common()
# -while

-----

# -- check 2
import vms_lib
data = 252*'*'
vms_lib.put_common(data)
while (1):
  try:
    data_from_common = vms_lib.get_common('ERR')
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_COMMON.C */
