/* VMS_LIB_GET_DATE_FORMAT.C -- 23-JUL-1999 Uwe Zessin
   Python interface to LIB$GET_DATE_FORMAT
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_get_date_format__doc[] =
"context, format_string = vms_lib.get_date_format ([user-context])\n\
Get the User's Date Input Format.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_date_format (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s   r_format_string;

	PyObject		* ar_user_context;
	unsigned long		  l_user_context;
	unsigned long		* al_user_context;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	ar_user_context = Py_None;
	l_user_context  = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|O", &ar_user_context ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user-context */
	if (ar_user_context == Py_None)
	{
	    al_user_context = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_user_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: user-context - must be integer or None");
		return NULL;
	    }
	    l_user_context = PyInt_AsLong(ar_user_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_user_context = &l_user_context;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$GET_DATE_FORMAT allocate the memory */
	r_format_string.dsc$w_length  = 0;
	r_format_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_format_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_format_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$get_date_format
		(&r_format_string
		,al_user_context
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    PyObject	* ar_strobj;

	    ar_strobj = Py_BuildValue
		("s#", (r_format_string.dsc$w_length == 0) ? /* empty string? */
		(void*)&r_format_string	 : /* non-NULL address */
		(void*)r_format_string.dsc$a_pointer
		,(unsigned int)r_format_string.dsc$w_length);
	    if (ar_strobj != NULL)
	    {
		if (al_user_context == 0)
		{
		    ar_return = Py_BuildValue ("lOO",
				l_status_lib, Py_None, ar_strobj);
		}
		else
		{
		    ar_return = Py_BuildValue ("llO",
				l_status_lib, l_user_context, ar_strobj);
		}
		Py_DECREF(ar_strobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_format_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_get_date_format: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free; /* fail anyway */
	        Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_get_date_format () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_DATE_FORMAT.C */
