/* VMS_LIB_GET_FOREIGN.C -- 11-DEC-1998 Uwe Zessin
   Python interface to LIB$GET_FOREIGN

   21-DEC-1997 ZE. -- created in VMS_LIB.C
   11-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_get_foreign__doc[] =
"resultant_string, flags_out = vms_lib.get_foreign ([prompt_string] [,flags])\n\
Get Foreign Command Line.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_foreign (PyObject *self, PyObject *args)
{
	char			* at_resultant_string;
	struct dsc$descriptor_s   r_resultant_string;
	unsigned long		  l_resultant_string_len;

	unsigned short int	  w_resultant_length;

	char			* at_prompt_string;
	struct dsc$descriptor_s   r_prompt_string;
	struct dsc$descriptor_s * ar_prompt_string;
	unsigned long		  l_prompt_string_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;
	unsigned long		* al_flags;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	at_prompt_string    = NULL;    l_prompt_string_len = 0;
	ar_flags            = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|z#O",
	    &at_prompt_string, &l_prompt_string_len,
	    &ar_flags))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 - prompt-string */
	if (at_prompt_string == NULL)
	{
	    ar_prompt_string = 0;	/* omitted */
	}
	else
	{
	    if (l_prompt_string_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	"argument 1: prompt-string - string size limited to 65535 characters");
		return NULL;
	    }
            /* set up string descriptor */
	    r_prompt_string.dsc$w_length  = l_prompt_string_len;
	    r_prompt_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_prompt_string.dsc$b_class   = DSC$K_CLASS_S;
	    r_prompt_string.dsc$a_pointer = at_prompt_string;
	    ar_prompt_string = &r_prompt_string;
        }

	/* -------------------- */
	/* argument 2 - flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}
	al_flags = &l_flags;	/* flags are always returned */

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$GET_FOREIGN allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$get_foreign
		(&r_resultant_string	/* resultant-string	*/
		,ar_prompt_string	/* [prompt-string]	*/
		,&w_resultant_length	/* [resultant-length]	*/
		,al_flags		/* [flags]		*/
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    PyObject * ar_strobj;

	    ar_strobj = Py_BuildValue
		("s#", (w_resultant_length == 0) ? /* empty string? */
		(void*)&r_resultant_string	 : /* non-NULL address */
		(void*)r_resultant_string.dsc$a_pointer
		,(unsigned int)w_resultant_length);
	    if (ar_strobj != NULL)
	    {
		if (al_flags == 0)
		{
		    l_flags = 0;	/* flags are always returned */
		}
		ar_return = Py_BuildValue ("Ol", ar_strobj, l_flags);
		Py_DECREF(ar_strobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_get_foreign: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_get_foreign () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
while (1):
  str, flags = vms_lib.get_foreign ('Prompt>', 0)
# -while

-----

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_FOREIGN.C */
