/* VMS_LIB_GET_MAXIMUM_DATE_LENGTH.C -- 23-JUL-1999 Uwe Zessin
   Python interface to LIB$GET_MAXIMUM_DATE_LENGTH

*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_get_maximum_date_l__doc[] =
"status, context, date_length = vms_lib.get_maximum_date_length\
 ([user-context], [flags])\n\
Retrieve the Maximum Length of a Date/Time String.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_maximum_date_length (PyObject *self, PyObject *args)
{
	unsigned long		  l_date_length;

	PyObject		* ar_user_context;
	unsigned long		  l_user_context;
	unsigned long		* al_user_context;

	PyObject		* ar_flags;
	unsigned long		  l_flags;
	unsigned long		* al_flags;


	unsigned long		  l_status;

	/* -------------------- */
	ar_user_context = Py_None;
	ar_flags        = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|OO",
	    &ar_user_context,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user-context */
	if (ar_user_context == Py_None)
	{
	    al_user_context = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_user_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: user_context - must be integer or None");
		return NULL;
	    }
	    l_user_context = PyInt_AsLong(ar_user_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_user_context = &l_user_context;
	}

	/* -------------------- */
	/* argument 2: flags */
	if (ar_flags == Py_None)
	{
	    al_flags = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_flags = &l_flags;
	}

	/* -------------------- */
	l_status = lib$get_maximum_date_length
		(&l_date_length
		,al_user_context
		,al_flags
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    if (al_user_context == 0)
	    {
		return Py_BuildValue ("lOl",
				l_status, Py_None, l_date_length);
	    }
	    else
	    {
		return Py_BuildValue ("lll",
				l_status, l_user_context, l_date_length);
	    }
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_get_maximum_date_length () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_MAXIMUM_DATE_LENGTH.C */
