/* VMS_LIB_GET_SYMBOL.C -- 20-DEC-1998 Uwe Zessin
   Python interface to LIB$GET_SYMBOL

   ??-???-???? ZE. -- created in VMS_LIB.C
   20-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_get_symbol__doc[] =
"resultant_string, table_type = vms_lib.get_symbol (symbol)\n\
Get Value of CLI Symbol.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_symbol (PyObject *self, PyObject *args)
{
	char			* at_symbol;
	struct dsc$descriptor_s   r_symbol;
	unsigned long		  l_symbol_len;

	struct dsc$descriptor_s   r_resultant_string;
	unsigned short int 	  w_resultant_length;

	long			  l_table_type_indicator;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#", &at_symbol, &l_symbol_len))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: symbol */
	if (l_symbol_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: symbol - string size limited to 65535 characters");
	    return NULL;
	}
	r_symbol.dsc$w_length  = l_symbol_len;
	r_symbol.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_symbol.dsc$b_class   = DSC$K_CLASS_S;
	r_symbol.dsc$a_pointer = at_symbol;

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$GET_SYMBOL allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$get_symbol
		(&r_symbol
		,&r_resultant_string
		,&w_resultant_length
		,&l_table_type_indicator
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    PyObject	* ar_strobj;

	    ar_strobj = Py_BuildValue
		("s#", (w_resultant_length == 0) ? /* empty string? */
		(void*)&r_resultant_string	 : /* non-NULL address */
		(void*)r_resultant_string.dsc$a_pointer
		,(unsigned int)w_resultant_length);
	    if (ar_strobj != NULL)
	    {
		ar_return = Py_BuildValue ("Ol",
				ar_strobj, l_table_type_indicator);
		Py_DECREF(ar_strobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	}
	else
	{
	    ar_return = NULL;
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_get_symbol: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free; /* fail anyway */
	        Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_get_symbol () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
symbol_name  = 'SET_SYMBOL_TEST'
symbol_value = 'X' * 255
vms_lib.set_symbol (symbol_name, symbol_value)
while (1):
  value, table = vms_lib.get_symbol (symbol_name)
# -while

-----

# -- check 2
import vms_lib
while (1):
  try:
    value, table = vms_lib.get_symbol (0)
  except (TypeError):
    pass
# -while

-----

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_SYMBOL.C */
