/* VMS_LIB_GET_USERS_LANGUAGE.C -- 26-DEC-1998 Uwe Zessin
   Python interface to LIB$GET_USERS_LANGUAGE

   ??-???-???? ZE. -- created in VMS_LIB.C
   26-DEC-1998 ZE. -- extract from VMS_LIB.C and change to dynamic string desc.
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
static char* at_english = "ENGLISH";		/* english language */
/* ------------------------------------------------------------------------- */

char vms_lib_get_ul__doc[] =
"users_language = vms_lib.get_users_language ()\n\
Return the User's Language.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_get_users_language (PyObject *self, PyObject *args)
{
	struct dsc$descriptor_s   r_language_string;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	/* no arguments taken */
	if (!PyArg_ParseTuple(args, ""))
	{
	    return NULL;
	}

	/* -------------------- */
	/* set up string descriptor */
	/*  let LIB$GET_USERS_LANGUAGE allocate the memory */
	r_language_string.dsc$w_length  = 0;
	r_language_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_language_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_language_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$get_users_language (&r_language_string);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    /* remove trailing blanks */
	    if (r_language_string.dsc$a_pointer != 0)
	    {
		long i;
		char * at_char;

		at_char = (char *)r_language_string.dsc$a_pointer;
                at_char += r_language_string.dsc$w_length;

		for (i = (r_language_string.dsc$w_length-1); i >= 0; i--)
		{
		    if (*at_char == ' ')
		    {
			*at_char = '\0';
			at_char--;
		    }
		    else
		    {
			break;
		    }
		}
	    } /* (r_language_string.dsc$a_pointer != 0) */

	    /* return string without trailing <SP> */
	    ar_return = Py_BuildValue
		("s#"
		,(r_language_string.dsc$w_length == 0) ? /* empty string? */
		 (void*)&r_language_string	       : /* non-NULL address */
		 (void*)r_language_string.dsc$a_pointer
		,(unsigned int)r_language_string.dsc$w_length);
	} /* (l_status_lib == SS$_NORMAL) */
	else
	{
	    if (l_status_lib == LIB$_ENGLUSED)
	    {
		/* use default language: english */
		ar_return = Py_BuildValue
		    ("s#", at_english, strlen(at_english));
	    }
	    else
	    {
		ar_return = NULL; /* /* Py_XDECREF below */
	    }
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_language_string);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_get_users_language: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free; /* fail anyway */
	        Py_XDECREF(ar_return);
	    }
	}

	/* -------------------- */
	if ((l_status_lib == SS$_NORMAL) || (l_status_lib == LIB$_ENGLUSED))
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_get_users_language () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
# don't have LNM 'SYS$LANGUAGE' defined ...
#  so test default
while (1):
  lang = vms_lib.get_users_language ()
# -while

-----

# -- check 1
import vms_lib
v = 255*'X'
dict = vms_lib.set_logical ('SYS$LANGUAGE', v)
while (1):
  lang = vms_lib.get_users_language ()
# -while

-----

# -- check 3
import vms_lib
while (1):
  try:
    lang = vms_lib.get_users_language ('ERR')
  except (TypeError):
    pass
# -while

-----

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GET_USERS_LANGUAGE.C */
