/* VMS_LIB_GETDVI.C -- 11-OCT-1998 Uwe Zessin
   Python interface to LIB$GETDVI()

   ??-???-1996 ZE. -- created in VMS_LIB.C
   11-OCT-1998 ZE. -- enhance argument 1 - allow tuple to request information
			about secondary device - see documentation.
   28-OCT-1998 ZE. -- convert r_resultant_string to dynamic descriptor use
   03-DEC-1998 ZE. -- improve parameter checks
   28-DEC-1998 ZE. -- call vms__cvt_bin2py() to build return-value of BWLQO
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
/* reference to translation table for DVI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$DVIDEF[];
/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type */
	,unsigned short int	   w_bufsiz		/* data length */
	);

/* ------------------------------------------------------------------------- */

char vms_lib_getdvi__doc[] =
"item_value = vms_lib.getdvi (item_name, channel_number [,device_name])\n\
Get Device/Volume Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_getdvi (PyObject *self, PyObject *args)
{
	PyObject		* ar_arg1;

	PyObject		* ar_item_code;
	char			* at_item_code;
	unsigned long		  l_item_code_len;
	unsigned long		  l_item_code;

	PyObject		* ar_item_mask;
	unsigned long		  l_item_mask;	/* .OR. with l_item_code */

	PyObject		* ar_channel;
	unsigned long		  l_channel;
	unsigned short int	  w_channel;
	unsigned short int	* aw_channel;

	char			* at_device_name;
	struct dsc$descriptor_s   r_device_name;
	struct dsc$descriptor_s * ar_device_name;
	unsigned long		  l_device_name_len;

	unsigned long		  l_integer_value;

	struct dsc$descriptor_d   r_resultant_string; /* dynamic ! */
	unsigned short int	  w_resultant_length;

	unsigned long		  l_trn_index; /* into VMSDEF_GR_$DVIDEF[] */
	unsigned short int	  w_styp_lib; /* ITMTYP_M_USIGN masked off */

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	l_item_mask       = 0;

	l_item_code_len   = 0;
	at_device_name    = NULL; l_device_name_len = 0;

	/* -------------------- */
	/* argument 2 must be None, even if omitted */
	/*                            v             */
	if (!PyArg_ParseTuple(args, "OO|z#",
		&ar_arg1,
		&ar_channel,
		&at_device_name, &l_device_name_len))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 : item code - string or tuple(string,integer) */
	if (PyString_Check(ar_arg1))
	{
	    l_item_code_len = PyString_Size(ar_arg1);
	    if (l_item_code_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	    "argument 1: item-code - string size limited to 65535 characters");
		return NULL;
	    }
	    at_item_code = PyString_AS_STRING(ar_arg1);
	}
	else
	{
	    /* argument 1 - can also be a tuple of ('DVI$_name',integer-mask) */
	    /*   integer-mask is DVI_M_SECONDARY */
	    if (!PyTuple_Check(ar_arg1))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: item-code - must be string or tuple");
		return NULL;
	    }
	    else
	    {
		/* extract item-code from first tuple element */
		ar_item_code = PyTuple_GetItem(ar_arg1, 0);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (!PyString_Check(ar_item_code))
		{
		    PyErr_SetString(PyExc_TypeError,
			"argument 1: item-code in tuple must be string");
		    return NULL;
		}
		l_item_code_len = PyString_Size(ar_item_code);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (l_item_code_len > 65535)
		{
		    PyErr_SetString(PyExc_ValueError,
	    "argument 1: item-code - string size limited to 65535 characters");
		    return NULL;
		}
		at_item_code = PyString_AS_STRING(ar_item_code);
		if (PyErr_Occurred())
		{
		    return NULL;
		}

		/* extract mask from second tuple element */
		ar_item_mask = PyTuple_GetItem(ar_arg1, 1);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (!PyInt_Check(ar_item_mask))
		{
		    PyErr_SetString(PyExc_TypeError,
		      "argument 1: item-mask in tuple must be 16-bit integer");
		    return NULL;
		}
		l_item_mask = PyInt_AsLong(ar_item_mask);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (l_item_mask > 65535)
		{
		    PyErr_SetString(PyExc_TypeError,
		    "argument 1: item-mask in tuple must be 16-bit integer");
		    return NULL;
		}
	    } /* - (!PyTyple_Check(ar_arg1)) */
	} /* - (PyString_Check(ar_arg1)) */

	/* -------------------- */
	/* convert item-code string to DVI$_ numerical value */
	l_item_code = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$DVIDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$DVIDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$DVIDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_item_code,VMSDEF_GR_$DVIDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* found textual match - use numerical value of item-code */
		l_item_code = (long)VMSDEF_GR_$DVIDEF[l_trn_index].w_itmcod;
		/* data type - mask off the (un)signed bit */
		w_styp_lib = VMSDEF_GR_$DVIDEF[l_trn_index].w_typ_lib &
			( ~ITMTYP_M_USIGN);
		break;
	    }
	  } /* if (VMSDEF_GR_$DVIDEF[l_trn_index].w_vmsvermin/max ... */
	  l_trn_index++;			/* check next item code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$DVIDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* item code not found - abort */
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: unknown DVI$_ item code");
	    return NULL;
	}

	/* combine item code with mask (DVI_M_SECONDARY) */
	l_item_code = l_item_code | l_item_mask;
	/* Warning! 'l_trn_index' is used after the RTL call. */

	/* -------------------- */
	/* argument 2 - channel */
	if (ar_channel == Py_None)
	{
	    aw_channel = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_channel))
	    {
		PyErr_SetString(PyExc_TypeError,
		  "argument 2: channel - must be 16-bit integer or None");
		return NULL;
	    }

	    l_channel = PyInt_AsLong(ar_channel);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_channel > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
		  "argument 2: channel - must be 16-bit integer or None");
		return NULL;
	    }
	    w_channel  = (unsigned short)l_channel;
	    aw_channel = &w_channel;
	}

	/* -------------------- */
	/* argument 3 - device-name */
	if (at_device_name == NULL)
	{
	    ar_device_name = 0;		/* omitted */
	}
	else
	{
	    if (l_device_name_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 3: device-name - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_device_name.dsc$w_length  = l_device_name_len;
	    r_device_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_device_name.dsc$b_class   = DSC$K_CLASS_S;
	    r_device_name.dsc$a_pointer = at_device_name;
	    ar_device_name = &r_device_name;
	}

	/* -------------------- */
	/* set up string descriptor for resultant-string - */
	/*  let LIB$GETDVI allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	/* -------------------- */
	l_status_lib = lib$getdvi
		(&l_item_code
		,aw_channel
		,ar_device_name
		,&l_integer_value
		,&r_resultant_string
		,&w_resultant_length
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    if (w_styp_lib == ITMTYP_K_ASCII)	/* @@ ASCIC not handled ! */
	    {
		/* return resultant-string */
		ar_return = Py_BuildValue ("s#",
		    (w_resultant_length == 0)  ? /* empty string? */
		    (void*)&r_resultant_string : /* non-NULL address */
		    (void*)r_resultant_string.dsc$a_pointer
		    , (unsigned int)w_resultant_length);
	    }
	    else
	    {
		/* return resultant-value (integer / boolean) */
		ar_return = vms__cvt_bin2py
		  ((char*)&l_integer_value		    /* data address */
		  ,VMSDEF_GR_$DVIDEF[l_trn_index].w_typ_lib /* data type */
		  ,VMSDEF_GR_$DVIDEF[l_trn_index].w_bufsiz  /* data length */
		  );
	    } /* else - (w_styp_lib == ITMTYP_K_ASCII) */
	}
	else
	{
	    ar_return = NULL; /* Py_XDECREF below */
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    /* check if error is already pending, if yes, print it */
	    if (PyErr_Occurred())
	    {
		(void) PyErr_Print();
	    }
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_getdvi: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
	    }
	}

	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;	/* can be NULL! */
	}

	Py_XDECREF (ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_getdvi () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
$python
import vms_lib
while (1):
  data = vms_lib.getdvi("DVI$_FREEBLOCKS",None,"SYS$SYSDEVICE:")
  data = vms_lib.getdvi("DVI$_VOLNAM",None,"SYS$SYSDEVICE:")
# -while

-----

# -- check 2
$python
import vms_lib
while (1):
  data = vms_lib.getdvi(("DVI$_MBX",1),None,"TT")
# -while

-----

# -- check 3
$python
import vms_lib
while (1):
  data = vms_lib.getdvi("DVI$_FREEBLOCKS",None,"TT")
  data = vms_lib.getdvi("DVI$_VOLNAM",None,"TT")
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GETDVI.C */
