/* VMS_LIB_GETJPI.C -- 03-DEC-1998 Uwe Zessin
   Python interface to LIB$GETJPI()

   ??-???-1996 ZE. -- created in VMS_LIB.C
   03-DEC-1998 ZE. -- convert r_resultant_string to dynamic descriptor use
   27-DEC-1998 ZE. -- support to return unsigned Quadwords
   28-DEC-1998 ZE. -- call vms__cvt_bin2py() to build return-value of BWLQO
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <jpidef.h>		/* JPI$_name */
#include <lib$routines.h>	/* LIB$name  */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
/* reference to translation table for JPI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$JPIDEF[];
/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type */
	,unsigned short int	   w_bufsiz		/* data length */
	);

/* ------------------------------------------------------------------------- */

char vms_lib_getjpi__doc[] =
"ctx_out, item_value = vms_lib.getjpi (item_name, pid_ctx [,process_name])\n\
Get Job/Process Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_getjpi (PyObject *self, PyObject *args)
{
	char			* at_item_code;
	unsigned long		  l_item_code_len;
	unsigned long		  l_item_code;

	long			  l_process_id; /* signed! <0 = wildcard */
	PyObject		* ar_process_id;

	char			* at_process_name;
	struct dsc$descriptor_s   r_process_name;
	struct dsc$descriptor_s * ar_process_name;
	unsigned long		  l_process_name_len;

	long			  q_resultant_value[2];

	struct dsc$descriptor_s   r_resultant_string;
	unsigned short int	  w_resultant_length;

	unsigned long		  l_trn_index; /* into VMSDEF_GR_$JPIDEF[]  */
	unsigned short int	  w_styp_lib;  /* ITMTYP_M_USIGN masked off */

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	l_item_code_len    = 0;
	l_process_id       = 0;
	at_process_name    = NULL; l_process_name_len = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#O|z#",
	    &at_item_code,    &l_item_code_len,
	    &ar_process_id,
	    &at_process_name, &l_process_name_len))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: item-code */
	if (l_item_code_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	    "argument 1: item-code - string size limited to 65535 characters");
	    return NULL;
	}

	/* -------------------- *
	/* convert item-code string to JPI$_ numerical value */
	l_item_code = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$JPIDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$JPIDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$JPIDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_item_code,VMSDEF_GR_$JPIDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* found textual match - use numerical value of item-code */
		l_item_code = (long)VMSDEF_GR_$JPIDEF[l_trn_index].w_itmcod;
		/* data type - mask off the (un)signed bit */
		w_styp_lib = VMSDEF_GR_$JPIDEF[l_trn_index].w_typ_lib &
			( ~ITMTYP_M_USIGN);
		break;
	    }
	  }
	  l_trn_index++;			/* check next item code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$JPIDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* item code not found - abort */
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: unknown JPI$_ item code");
	    return NULL;
	}
	/* Warning! 'l_trn_index' is used after the RTL call. */

	/* -------------------- */
	/* argument 2: process-id */
	if (ar_process_id == Py_None)
	{
	    l_process_id = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_process_id))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: process-id - must be integer or None");
		return NULL;
	    }
	    l_process_id = PyInt_AsLong(ar_process_id);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 3: process-name */
	if (at_process_name == NULL)
	{
	    ar_process_name = 0;	/* omitted */
	}
	else
	{
	    if (l_process_name_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	 "argument 3: process-name - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_process_name.dsc$w_length  = l_process_name_len;
	    r_process_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_process_name.dsc$b_class   = DSC$K_CLASS_S;
	    r_process_name.dsc$a_pointer = at_process_name;
	    ar_process_name = &r_process_name;
	}

	/* -------------------- */
	/* set up string descriptor for resultant-string */
	/*  let LIB$GETJPI allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	q_resultant_value[0] = 0;
	q_resultant_value[1] = 0;

	/* -------------------- */
	l_status_lib = lib$getjpi
		(&l_item_code
		,&l_process_id
		,ar_process_name	/* optional */
		,&q_resultant_value[0]
		,&r_resultant_string
		,&w_resultant_length
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	  /* -------------------- */
	  /* special handling for PID with wildcard context */
	  if (l_item_code == JPI$_PID)
	  {
	    if (l_process_id > 0)	/* real PID, no wildcard context */
	    {
	      q_resultant_value[0] = l_process_id;
	    }
	  }

	  /* -------------------- */
	  if (w_styp_lib == ITMTYP_K_ASCII)	/* @@ ASCIC not handled ! */
	  {
	    /* return resultant-string */
	    ar_return = Py_BuildValue ("ls#", l_process_id,
		(w_resultant_length == 0)  ? /* empty string? */
		(void*)&r_resultant_string : /* non-NULL address */
		(void*)r_resultant_string.dsc$a_pointer
		, (unsigned int)w_resultant_length);
	  }
	  else
	  {
	    PyObject * ar_intobj; /* can be BWLQO or tuple(BWLQO) */

	    /* return resultant-value (integer / boolean) */
	    ar_intobj = vms__cvt_bin2py
		((char*)&q_resultant_value[0]		  /* data address */
		,VMSDEF_GR_$JPIDEF[l_trn_index].w_typ_lib /* data type */
		,VMSDEF_GR_$JPIDEF[l_trn_index].w_bufsiz  /* data length */
		);

	    /*-------*/
	    if (ar_intobj != NULL)
	    {
		/* return PID/context-value and resultant-value */
		ar_return = Py_BuildValue("lO", l_process_id, ar_intobj);
		Py_DECREF(ar_intobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	  } /* else - (w_styp_lib == ITMTYP_K_ASCII) */
	} /* (l_status_lib == SS$_NORMAL) */
        else
	{
	    ar_return = NULL; /* Py_XDECREF below */
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    /* check if error is already pending, if yes, print it */
	    if (PyErr_Occurred())
	    {
		(void) PyErr_Print();
	    }
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_getjpi: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
	    }
	}

	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF (ar_return);	/* can be NULL! */

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_getjpi () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
$python
import vms_lib
while (1):
  pid, l_state = vms_lib.getjpi ('JPI$_STATE',0)
# -while

-----

# -- check 2
$python
import vms_lib
while (1):
  pid, t_prcnam = vms_lib.getjpi ('JPI$_PRCNAM',0)
# -while

-----

# -- check 3
$python
import vms_lib
while (1):
  pid, q_lgitim = vms_lib.getjpi ('JPI$_LOGINTIM',0)
  pid, q_curprv = vms_lib.getjpi ('JPI$_CURPRIV',0)
# -while

-----

# -- check 4
$ set PROCESS /PRIVILEGE= (WORLD)
$ python
import vms_lib
import vms_sys
while 1:
  ctx = -1
  try:
    while 1:
      ctx,pid = vms_lib.getjpi ('JPI$_PID',ctx)
      x,pn = vms_lib.getjpi ('JPI$_PRCNAM',pid)
      x,li = vms_lib.getjpi ('JPI$_LOGINTIM',pid)
      # print ctx,pid,pn,vms_sys.asctim(li)
    #-while
  except(vms_lib.error): # SS$_NOMOREPROC
    pass
#-while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GETJPI.C */
