/* VMS_LIB_GETQUI.C -- 29-OCT-1998 Uwe Zessin
   Python interface to LIB$GETQUI()

   29-OCT-1998 ZE. -- convert r_resultant_string to dynamic descriptor use
			optimize argument handling
   04-DEC-1998 ZE. -- increase robustness
   28-DEC-1998 ZE. -- call vms__cvt_bin2py() to build return-value of BWLQO
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <quidef.h>		/* QUI$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
/* reference to translation table for QUI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$QUIDEF[];
/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type */
	,unsigned short int	   w_bufsiz		/* data length */
	);

/* ------------------------------------------------------------------------- */

char vms_lib_getqui__doc[] =
"result = vms_lib.getqui (function_code, item_name, \
search_number, search_name, search_flags)\n\
Get Queue Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_getqui (PyObject *self, PyObject *args)
{
	char			* at_function_code;
	unsigned long		  l_function_code_len;
	unsigned long		  l_function_code;

	char			* at_item_code;
	unsigned long		  l_item_code_len;
	unsigned long		  l_item_code;

	PyObject		* ar_search_number;
	long			  l_search_number;
	long			* al_search_number;

	char			* at_search_name;
	unsigned long		  l_search_name_len;
	struct dsc$descriptor_s   r_search_name;
	struct dsc$descriptor_s * ar_search_name;

	PyObject		* ar_search_flags;
	unsigned long		  l_search_flags;

	long			  q_resultant_value[2];

	struct dsc$descriptor_d   r_resultant_string;
	unsigned short int	  w_resultant_length;

	unsigned long		  l_trn_index;	/* into VMSDEF_GR_$QUIDEF[]  */
	unsigned short int	  w_styp_lib;	/* ITMTYP_M_USIGN masked off */

	unsigned long		  x_onearg;	/* only one argment given */

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	ar_search_number = Py_None;
	at_search_name   = NULL;     l_search_name_len = 0;
	ar_search_flags  = Py_None;

	/* -------------------- */
	/* this is for QUI$_CANCEL_OPERATION */
	if (PyArg_ParseTuple(args, "s#",
	    &at_function_code, &l_function_code_len))
	{
	    x_onearg = 1;
	}
	else
	{
	    /* all other function (and item codes) */
	    (void) PyErr_Clear();
	    if (!PyArg_ParseTuple(args, "s#s#|Oz#O"
		,&at_function_code, &l_function_code_len
		,&at_item_code,     &l_item_code_len
		,&ar_search_number
		,&at_search_name,   &l_search_name_len
		,&ar_search_flags
		))
	    {
		return NULL;
	    }
	    x_onearg = 0;
	}

	/* -------------------- */
	/* argument 1: function-code */
	if (l_function_code_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	"argument 1: function-code - string size limited to 65535 characters");
	    return NULL;
	}

	/* convert function-code string to QUI$_ numerical value */
	l_function_code = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_function_code,VMSDEF_GR_$QUIDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* check if item is really a function code - item 'R' */
		if (! (VMSDEF_GR_$QUIDEF[l_trn_index].l_flags &
			ITMTBL_M_GETQUI_FNCREQ)
		   )
		{
		    /* wrong type of function code - abort */
		    PyErr_SetString(PyExc_ValueError,
			"argument 1: not a QUI$_ request function code");
		    return NULL;
		}
		/* found textual match - use numerical value of function-code */
		l_function_code = (long)VMSDEF_GR_$QUIDEF[l_trn_index].w_itmcod;
		break;
	    }
	  }
	  l_trn_index++;			/* check next function code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* function code not found - abort */
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: unknown QUI$_ function code");
	    return NULL;
	}

	/* -------------------- */
	/* CANCEL_OPERATION uses only one argument */
	if (l_function_code == QUI$_CANCEL_OPERATION)
	{
	    if (!x_onearg)
	    {
		PyErr_SetString(PyExc_TypeError,
		    "QUI$_CANCEL_OPERATION requires exactly one argument");
		return NULL;
	    }

	    /* This crashes the program on some VMS version when	*/
	    /* QUI$_CANCEL_OPERATION is used after a different function */
	    /* -->  l_status_lib = lib$getqui (&l_function_code);   <-- */

	    /* this appears to work */
	    l_status_lib = lib$getqui
		(&l_function_code ,0
		,0 ,0
		,0
		,0
		,0 ,0
		);

	    /* ---------- */
	    if (l_status_lib == SS$_NORMAL)
	    {
		Py_INCREF(Py_None);
		return Py_None;
	    }

	    /* ---------- */
	    /* error */
	    return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
	} /* (l_function_code == QUI$_CANCEL_OPERATION) */

	/* -------------------- */
	/* all other functions require more arguments */
	if (x_onearg)
	{
	    PyErr_SetString(PyExc_TypeError,
		"function requires at least 2 arguments; 1 given");
	    return NULL;
	}

	/* -------------------- */
	/* argument 2: item-code */
	if (l_item_code_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	    "argument 2: item-code - string size limited to 65535 characters");
	    return NULL;
	}

	/* convert item-code string to QUI$_ numerical value */
	l_item_code = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_item_code,VMSDEF_GR_$QUIDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* check that this item is not a function request code */
		if ((VMSDEF_GR_$QUIDEF[l_trn_index].l_flags &
			ITMTBL_M_GETQUI_FNCREQ)
		   )
		{
		    /* wrong type of item code - abort */
		    PyErr_SetString(PyExc_ValueError,
			"argument 2: wrong QUI$_ item code for this argument");
		    return NULL;
		}
		/* found textual match - use numerical value of item-code */
		l_item_code = (long)VMSDEF_GR_$QUIDEF[l_trn_index].w_itmcod;
		/* data type - mask off the (un)signed bit */
		w_styp_lib = VMSDEF_GR_$QUIDEF[l_trn_index].w_typ_lib &
			( ~ITMTYP_M_USIGN);
		break;
	    }
	  }
	  l_trn_index++;			/* check next item code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$QUIDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* item-code not found - abort */
	    PyErr_SetString(PyExc_ValueError,
		"argument 2: unknown QUI$_ item code");
	    return NULL;
	}
	/* Warning! 'l_trn_index' is used after the RTL call. */

	/* -------------------- */
	/* argument 3: search-number */
	if (ar_search_number == Py_None)
	{
	    al_search_number = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_search_number))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: search-number - must be integer or None");
		return NULL;
	    }
	    l_search_number  = PyInt_AsLong(ar_search_number);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
            al_search_number = &l_search_number;
	}

	/* -------------------- */
	/* argument 4: search-name */
	if (at_search_name == NULL)
	{
	    ar_search_name = 0;		/* omitted */
	}
	else
	{
	    if (l_search_name_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 4: search-name - string size limited to 65535 characters");
		return NULL;
	    }

	    /* set up string descriptor for search-name */
	    r_search_name.dsc$w_length  = l_search_name_len;
	    r_search_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_search_name.dsc$b_class   = DSC$K_CLASS_S;
	    r_search_name.dsc$a_pointer = at_search_name;
	    ar_search_name = &r_search_name;
	}

	/* -------------------- */
	/* argument 5: search_flags */
	if (ar_search_flags == Py_None)
	{
	    l_search_flags = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_search_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: search-flags - must be integer or None");
		return NULL;
	    }
	    l_search_flags = PyInt_AsLong(ar_search_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* set up string descriptor for resultant-string - */
	/*  let LIB$GETQUI allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	q_resultant_value[0] = 0;
	q_resultant_value[1] = 0;

	/* -------------------- */
	/* search-number overrides search-name - */
	/*  otherwise: %JBC-F-INVITMCOD, */
	if (al_search_number != 0)
	{
	    ar_search_name = 0;
	}

	/* -------------------- */
	l_status_lib = lib$getqui
		(&l_function_code
		,&l_item_code
		,al_search_number
		,ar_search_name
		,&l_search_flags
		,&q_resultant_value[0]
		,&r_resultant_string
		,&w_resultant_length
		);

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	  if (w_styp_lib == ITMTYP_K_ASCII)	/* @@ ASCIC not handled ! */
	  {
	    /* return resultant-string */
	    ar_return = Py_BuildValue ("s#",
		    (w_resultant_length == 0)  ? /* empty string? */
		    (void*)&r_resultant_string : /* non-NULL address */
		    (void*)r_resultant_string.dsc$a_pointer
		    , (unsigned int)w_resultant_length);
	  }
	  else
	  {
	    /* return resultant-value (integer / boolean) */
	    ar_return = vms__cvt_bin2py
		((char*)&q_resultant_value[0]		  /* data address */
		,VMSDEF_GR_$QUIDEF[l_trn_index].w_typ_lib /* data type */
		,VMSDEF_GR_$QUIDEF[l_trn_index].w_bufsiz  /* data length */
		);
	  } /* else - (w_styp_lib == ITMTYP_K_ASCII) */
	} /* (l_status_lib == SS$_NORMAL) */
	else
	{
	    ar_return = NULL; /* Py_XDECREF below */
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    /* check if error is already pending, if yes, print it */
	    if (PyErr_Occurred())
	    {
		(void) PyErr_Print();
	    }
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_getqui: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);	/* can be NULL! */

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_getqui () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
$python
import vms_lib
while (1):
  data = vms_lib.getqui ("QUI$_DISPLAY_ENTRY","QUI$_JOB_NAME",5)
  data = vms_lib.getqui ("QUI$_DISPLAY_ENTRY","QUI$_PRIORITY",5)
  data = vms_lib.getqui ("QUI$_DISPLAY_ENTRY","QUI$_SUBMISSION_TIME",5)
# -while

-----

# -- check 2
$python
import vms_quidef, vms_lib
while 1:
  vms_lib.getqui ("QUI$_CANCEL_OPERATION")
  while 1:
    queue_name = ''
    try:
      queue_name = vms_lib.getqui("QUI$_DISPLAY_QUEUE",
        "QUI$_QUEUE_NAME",None,'*')
    except vms_lib.error:
      break
    queue_desc = vms_lib.getqui("QUI$_DISPLAY_QUEUE",
      "QUI$_QUEUE_DESCRIPTION",None,'*',vms_quidef.QUI_M_SEARCH_FREEZE_CONTEXT)
    print 'Queue:', queue_name, '<', queue_desc, '>'
    while 1:
      try:
        js = vms_lib.getqui("QUI$_DISPLAY_JOB",
           "QUI$_JOB_STATUS",-1,'*', vms_quidef.QUI_M_SEARCH_ALL_JOBS)
      except vms_lib.error:
         break
      jn = vms_lib.getqui("QUI$_DISPLAY_JOB",
         "QUI$_JOB_NAME",-1,'*', vms_quidef.QUI_M_SEARCH_ALL_JOBS+
         vms_quidef.QUI_M_SEARCH_FREEZE_CONTEXT)
      en = vms_lib.getqui("QUI$_DISPLAY_JOB",
         "QUI$_ENTRY_NUMBER",-1,'*', vms_quidef.QUI_M_SEARCH_ALL_JOBS+
         vms_quidef.QUI_M_SEARCH_FREEZE_CONTEXT)
      print 'Job:', jn, '(', en, ')'
      while 1:
        try:
          fs = vms_lib.getqui("QUI$_DISPLAY_FILE",
            #"QUI$_FILE_IDENTIFICATION", None, None, # "QUI$_FILE_STATUS", 
            "QUI$_FILE_SPECIFICATION", None, None, # "QUI$_FILE_STATUS", 
            vms_quidef.QUI_M_SEARCH_ALL_JOBS)
          print 'file=', fs
        except vms_lib.error, value:
          if (value[0] == 295314): # JBC$_NOMOREFILE
            break
          else:
            raise
      # -while
    # -while
  # -while
# -while

-----

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GETQUI.C */
