/* VMS_LIB_GETSYI.C -- 11-OCT-1998 Uwe Zessin
   Python interface to LIB$GETSYI()

   11-OCT-1998 ZE. -- add return of tuples of BWL
   29-OCT-1998 ZE. -- convert r_resultant_string to dynamic descriptor use
			optimize argument handling
   30-OCT-1998 ZE. -- fix bug with dynamic string - empty must not return None
   04-DEC-1998 ZE. -- increase robustness
   25-DEC-1998 ZE. -- fix refcount bug (returning data tuple)
   27-DEC-1998 ZE. -- support to return unsigned Quadwords
   28-DEC-1998 ZE. -- call vms__cvt_bin2py() to build return-value of BWLQO
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;

extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */
/* reference to translation table for SYI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$SYIDEF[];
/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
	(char			 * ab_data_addr		/* data address */
	,unsigned short int	   w_data_type		/* data type */
	,unsigned short int	   w_bufsiz		/* data length */
	);

/* ------------------------------------------------------------------------- */

char vms_lib_getsyi__doc[] =
"ctx_out, item_value = vms_lib.getsyi (item_name, csid_ctx [,node_name])\n\
Get Systemwide Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_getsyi (PyObject *self, PyObject *args)
{
	char			* at_item_code;
	unsigned long		  l_item_code_len;
	unsigned long		  l_item_code;

	PyObject		* ar_system_id;
	long			  l_system_id;  /* <0 = wildcard */

	char			* at_node_name;
	struct dsc$descriptor_s   r_node_name;
	struct dsc$descriptor_s * ar_node_name;
	unsigned long		  l_node_name_len;

	long			  q_resultant_value[2];

	struct dsc$descriptor_d   r_resultant_string;
	unsigned short int	  w_resultant_length;

	unsigned long		  l_trn_index;	/* into VMSDEF_GR_$SYIDEF[]  */
	unsigned short int	  w_styp_lib;	/* ITMTYP_M_USIGN masked off */

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	at_node_name = NULL; l_node_name_len = 0;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#O|z#",
	    &at_item_code, &l_item_code_len,
	    &ar_system_id,
	    &at_node_name, &l_node_name_len))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1 - item-code */
	if (l_item_code_len > 65535)
	{
	    PyErr_SetString(PyExc_TypeError,
	    "argument 1: item-code - string size limited to 65535 characters");
	    return NULL;
	}

	/* convert item-code string to SYI$_ numerical value */
	l_item_code = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$SYIDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$SYIDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$SYIDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_item_code,VMSDEF_GR_$SYIDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* found textual match - use numerical value of item-code */
		l_item_code = (long)VMSDEF_GR_$SYIDEF[l_trn_index].w_itmcod;
		/* data type - mask off the (un)signed bit */
		w_styp_lib = VMSDEF_GR_$SYIDEF[l_trn_index].w_typ_lib &
			( ~ITMTYP_M_USIGN);
		break;
	    }
	  }
	  l_trn_index++;			/* check next item code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$SYIDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* item code not found - abort */
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: unknown SYI$_ item code");
	    return NULL;
	}
	/* Warning! 'l_trn_index' is used after the RTL call. */

	/* -------------------- */
	/* argument 2 - system-id */
	if (ar_system_id == Py_None)
	{
	    l_system_id = 0;		/* return csid argument */
	}
	else
	{
	    if (!PyInt_Check(ar_system_id))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: cluster-system-id - must be integer or None");
		return NULL;
	    }
	    l_system_id = PyInt_AsLong(ar_system_id);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 3 - node-name */
	if (at_node_name == NULL)
	{
	    ar_node_name = 0;		/* omitted */
	}
	else
	{
	    if (l_node_name_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	    "argument 3: node-name - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_node_name.dsc$w_length  = l_node_name_len;
	    r_node_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_node_name.dsc$b_class   = DSC$K_CLASS_S;
	    r_node_name.dsc$a_pointer = at_node_name;
	    ar_node_name = &r_node_name;
	}

	/* -------------------- */
	/* set up string descriptor for resultant-string - */
	/*  let LIB$GETSYI allocate the memory */
	r_resultant_string.dsc$w_length  = 0;
	r_resultant_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resultant_string.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_resultant_string.dsc$a_pointer = 0;

	q_resultant_value[0] = 0;
	q_resultant_value[1] = 0;

	/* -------------------- */
	l_status_lib = lib$getsyi
	    (&l_item_code
	    ,&q_resultant_value[0]
	    ,&r_resultant_string
	    ,&w_resultant_length
	    ,&l_system_id
	    ,ar_node_name		/* optional */
	    );

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	  if (w_styp_lib == ITMTYP_K_ASCII)	/* @@ ASCIC not handled ! */
	  {
	    /* return CSID/context-value and resultant-string (ASCII) */
	    ar_return = Py_BuildValue ("ls#", l_system_id,
		    (w_resultant_length == 0)  ? /* empty string? */
		    (void*)&r_resultant_string : /* non-NULL address */
		    (void*)r_resultant_string.dsc$a_pointer
		    , (unsigned int)w_resultant_length);

	  }
	  else
	  {
	    PyObject * ar_intobj; /* can be BWLQO or tuple(BWLQO) */

	    /* return resultant-value (integer / boolean) */
	    ar_intobj = vms__cvt_bin2py
		((char*)&q_resultant_value[0]		  /* data address */
		,VMSDEF_GR_$SYIDEF[l_trn_index].w_typ_lib /* data type */
		,VMSDEF_GR_$SYIDEF[l_trn_index].w_bufsiz  /* data length */
		);

	    /*-------*/
	    if (ar_intobj != NULL)
	    {
		/* return SID/context-value and resultant-value */
		ar_return = Py_BuildValue("lO", l_system_id, ar_intobj);
		Py_DECREF(ar_intobj);
	    }
	    else
	    {
		ar_return = NULL;
	    }
	  } /* else - (w_styp_lib == ITMTYP_K_ASCII) */
	} /* (l_status_lib == SS$_NORMAL) */
	else
	{
	    ar_return = NULL; /* Py_XDECREF below */
	}

	/* -------------------- */
	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_resultant_string);
	if (l_status_free != SS$_NORMAL)
	{
	    /* check if error is already pending, if yes, print it */
	    if (PyErr_Occurred())
	    {
		(void) PyErr_Print();
	    }
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_getsyi(): LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
	    }
	}

	/* -------------------- */
	if (l_status_lib == SS$_NORMAL)
	{
	    return ar_return;
	}

	Py_XDECREF(ar_return);	/* can be NULL */

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_getsyi () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
$python
import vms_lib
while (1):
  csid, item = vms_lib.getsyi ('SYI$_NODENAME',0)
  csid, item = vms_lib.getsyi ("SYI$_PAGFILCNT",0)
  csid, item = vms_lib.getsyi ('SYI$_NODE_HWVERS',0)
  csid, item = vms_lib.getsyi ('SYI$_BOOTTIME',0)
# -while

-----

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_GETSYI.C */
