/* VMS_LIB_INIT_DATE_TIME_CONTEXT.C -- 23-JUL-1999 Uwe Zessin
   Python interface to LIB$INIT_DATE_TIME_CONTEXT

*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_init_date_time_ctx__doc[] =
"context = vms_lib.init_date_time_context (user-context, component,\
 init-string)\n\
Initialize the Context Area Used in Formatting\
 Dates and Times for Input or Output.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_init_date_time_context (PyObject *self, PyObject *args)
{
	unsigned long		  l_user_context;

	long			  l_component;

	char			* at_init_string;
	struct dsc$descriptor_s   r_init_string;
	unsigned long		  l_init_string_len;

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "lls#",
	    &l_user_context,
	    &l_component,
	    &at_init_string, &l_init_string_len ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user-context */
	/* done by PyArg_ParseTuple() */

	/* -------------------- */
	/* argument 2: component*/
	/* done by PyArg_ParseTuple() */

	/* -------------------- */
	/* argument 3: init_string */
	if (l_init_string_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 3: init-string - string size limited to 65535 characters");
	    return NULL;
	}
	r_init_string.dsc$w_length  = l_init_string_len;
	r_init_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_init_string.dsc$b_class   = DSC$K_CLASS_S;
	r_init_string.dsc$a_pointer = at_init_string;

	/* -------------------- */
	l_status = lib$init_date_time_context
		(&l_user_context
		,&l_component
		,&r_init_string
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    return Py_BuildValue ("l", l_user_context);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status);
} /* vms_lib_init_date_time_context () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_INIT_DATE_TIME_CONTEXT.C */
