/* VMS_LIB_PARSE_ACCESS_CODE.C -- 12-AUG-1999 Uwe Zessin
   Python interface to LIB$PARSE_ACCESS_CODE()
*/

#ifdef __DECC
#pragma module VMS_LIB_PARSE_ACCESS_CODE "19990823"
#endif

#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
#include <lib$routines.h>	/* LIB$name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

#ifndef __ALPHA		/* lib$parse_access_code defined in Alpha/DEC C V5.2 */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long lib$parse_access_code(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
#endif /* __ALPHA */

/* ------------------------------------------------------------------------- */

char vms_lib_parse_access_code__doc[] =
"status, access-mask, end-position = vms_lib.parse_access_code (\
access-string, [access-names], ownership-category)\n\
Parse Access Encoded Name String.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_parse_access_code (PyObject *self, PyObject *args)
{
	char			* at_access_string;
	struct dsc$descriptor_s   r_access_string;
	unsigned long		  l_access_string_len;

	PyObject		* ar_accnam;
	long			* aq_access_names;

	unsigned long		  l_ownership_category;
	unsigned short int	  w_ownership_category;

	unsigned short int	  w_access_mask;

	short int	  	  w_end_position;

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#Oi",
	    &at_access_string, &l_access_string_len,
	    &ar_accnam,
	    &l_ownership_category
	    ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: access_string */
	if (l_access_string_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	"argument 1: access_string - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up descriptor */
	r_access_string.dsc$w_length  = l_access_string_len;
	r_access_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_access_string.dsc$b_class   = DSC$K_CLASS_S;
	r_access_string.dsc$a_pointer = at_access_string;

	/* -------------------- */
	/* argument 2: access_names */
	if (ar_accnam == Py_None)
	{
	    aq_access_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__access_names_Check(ar_accnam))
	    {
		PyErr_SetString(PyExc_TypeError,
	    "argument 2: access_names - must be vmsobj__access_names or None");
		return NULL;
	    }
	    aq_access_names =
			((vmsobj__access_names *) ar_accnam)->aq_access_names;
	}

	/* -------------------- */
	/* argument 3: ownership_category - done by PyArg_ParseTuple() */
	w_ownership_category = l_ownership_category;

	/* -------------------- */
	w_access_mask  = 0;
	w_end_position = 0;
	l_status = lib$parse_access_code
			(&r_access_string
			,aq_access_names
			,&w_ownership_category
			,&w_access_mask
			,&w_end_position
			);

	/* -------------------- */
	return Py_BuildValue ("lll", l_status,
			(unsigned int)w_access_mask,
			(int)w_end_position);

} /* vms_lib_parse_access_code () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_PARSE_ACCESS_CODE.C */
