/* VMS_LIB_PARSE_SOGW_PROT.C -- 13-AUG-1999 Uwe Zessin
   Python interface to LIB$PARSE_SOGW_PROT()
*/

#ifdef __DECC
#pragma module VMS_LIB_PARSE_SOGW_PROT "19990823"
#endif

#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
#include <lib$routines.h>	/* LIB$name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

#ifndef __ALPHA		/* lib$parse_sogw_prot defined in Alpha/DEC C V5.2 */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long lib$parse_sogw_prot(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
#endif /* __ALPHA */

/* ------------------------------------------------------------------------- */

char vms_lib_parse_sogw_prot__doc[] =
"status, protection-mask, ownership-mask, end-position =\
 vms_lib.parse_sogw_prot (protection-string, [access-names])\n\
Parse Protection String.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_parse_sogw_prot (PyObject *self, PyObject *args)
{
	char			* at_protection_string;
	struct dsc$descriptor_s   r_protection_string;
	unsigned long		  l_protection_string_len;

	PyObject		* ar_accnam;
	long			* aq_access_names;

	unsigned short int	  w_protection_mask;

	unsigned short int	  w_ownership_mask;

	short int	  	  w_end_position;

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#O",
	    &at_protection_string, &l_protection_string_len,
	    &ar_accnam
	    ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: protection_string */
	if (l_protection_string_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	"argument 1: protection_string - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up descriptor */
	r_protection_string.dsc$w_length  = l_protection_string_len;
	r_protection_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_protection_string.dsc$b_class   = DSC$K_CLASS_S;
	r_protection_string.dsc$a_pointer = at_protection_string;

	/* -------------------- */
	/* argument 2: access_names */
	if (ar_accnam == Py_None)
	{
	    aq_access_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__access_names_Check(ar_accnam))
	    {
		PyErr_SetString(PyExc_TypeError,
	    "argument 2: access_names - must be vmsobj__access_names or None");
		return NULL;
	    }
	    aq_access_names =
			((vmsobj__access_names *) ar_accnam)->aq_access_names;
	}

	/* -------------------- */
	w_protection_mask = 0;
	w_ownership_mask  = 0;
	w_end_position    = 0;
	l_status = lib$parse_sogw_prot
			(&r_protection_string
			,aq_access_names
			,&w_protection_mask
			,&w_ownership_mask
			,&w_end_position
			);

	/* -------------------- */
	return Py_BuildValue ("llll", l_status,
			(unsigned int)w_protection_mask,
			(unsigned int)w_ownership_mask,
			(int)w_end_position);

} /* vms_lib_parse_sogw_prot () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_PARSE_SOGW_PROT.C */
