/* VMS_LIB_SET_LOGICAL.C -- 27-DEC-1998 Uwe Zessin
   Python interface to LIB$SET_LOGICAL

   10-JAN-1998 ZE. -- created in VMS_LIB.C w/o item-list
   11-JAN-1998 ZE. -- start SET_LOGICAL item-list support
   12-JAN-1998 ZE. -- continue SET_LOGICAL item-list support
   15-JAN-1998 ZE. -- continue SET_LOGICAL, close all memory leaks that
                        have (intentionally) been left open during testing
   27-DEC-1998 ZE. -- extract from VMS_LIB.C and modify to use common
			item-list routines
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name */
#include <ssdef.h>		/* SS$_name */

/* ------------------------------------------------------------------------- */
/* reference to translation table for LNM$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$LNMDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_lib_set_logical__doc[] =
"dict = vms_lib.set_logical (logical-name, [value-string], [table] \
[,attributes] [,itemlist])\n\
Set Logical Name.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_set_logical (PyObject *self, PyObject *args)
{
	char			* at_logical_name;
	struct dsc$descriptor_s   r_logical_name;
	unsigned long		  l_logical_name_len;

	char			* at_value_string;
	struct dsc$descriptor_s   r_value_string;
	struct dsc$descriptor_s * ar_value_string;
	unsigned long		  l_value_string_len;

	char			* at_table;
	struct dsc$descriptor_s   r_table;
	struct dsc$descriptor_s * ar_table;
	unsigned long		  l_table_len;

	PyObject		* ar_py_attributes;
	unsigned long		  l_attributes;
	unsigned long		* al_attributes;

	/* item-list - tuples of tuples = (('LNM$_name',data), ...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to LIB$SET_LOGICAL() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	at_value_string  = NULL;    l_value_string_len = 0;
	at_table         = NULL;    l_table_len = 0;
	ar_py_attributes = Py_None;
	ar_py_item_list  = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|z#z#OO",
	    &at_logical_name, &l_logical_name_len,
	    &at_value_string, &l_value_string_len,
	    &at_table,        &l_table_len,
	    &ar_py_attributes,
	    &ar_py_item_list))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: logical-name */
	if (l_logical_name_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	 "argument 1: logical-name - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_logical_name.dsc$w_length  = l_logical_name_len;
	r_logical_name.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_logical_name.dsc$b_class   = DSC$K_CLASS_S;
	r_logical_name.dsc$a_pointer = at_logical_name;

	/* -------------------- */
	/* argument 2: value-string (optional/ignored, if item-list) */
	if (at_value_string == NULL)
	{
	    ar_value_string = 0;	/* omitted */
	}
	else
	{
	    if (l_value_string_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	 "argument 2: value-string - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_value_string.dsc$w_length  = l_value_string_len;
	    r_value_string.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_value_string.dsc$b_class   = DSC$K_CLASS_S;
	    r_value_string.dsc$a_pointer = at_value_string;
	    ar_value_string = &r_value_string;
	}

	/* -------------------- */
	/* argument 3: table */
	if (at_table == NULL)
	{
	    ar_table = 0;		/* omitted */
	}
	else
	{
	    if (l_table_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		"argument 3: table - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_table.dsc$w_length  = l_table_len;
	    r_table.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_table.dsc$b_class   = DSC$K_CLASS_S;
	    r_table.dsc$a_pointer = at_table;
	    ar_table = &r_table;
	}

	/* -------------------- */
	/* argument 4: attributes */
	if (ar_py_attributes == Py_None)
	{
	    al_attributes = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_py_attributes))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: attributes - must be integer or None");
		return NULL;
	    }
	    l_attributes  = PyInt_AsLong(ar_py_attributes);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_attributes = &l_attributes;
	}

	/* -------------------- */
	/* argument 5: item-list */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist = 0;		/* omitted */
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$LNMDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	} /* - if (ar_py_item_list == Py_None)) */

	/* -------------------- */
	l_status = lib$set_logical
		(&r_logical_name
		,ar_value_string
		,ar_table
		,al_attributes
		,ar_itemlist
		);

	/* -------------------- */
	/* create a dictionary because the user might have specified an */
	/*  output-item in the item-list */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* always return the status code - SS$_SUPERSEEDE is also success */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) != 0)
	{
	    Py_DECREF(ar_dictobj);
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* build remaining items only if 'success' */
	if ((l_status == SS$_NORMAL) || (l_status == SS$_BUFFEROVF) ||
	    (l_status == SS$_SUPERSEDE)					)
	{
	  /* process item-list only if it was specified */
	  if (ar_py_item_list != Py_None)
	  {
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$LNMDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	  }
	} /* if (l_status == (SS$_NORMAL || SS$_BUFFEROVF || SS$_SUPERSEDE)) */

	/* -------------------- */
	if (ar_py_item_list != Py_None)
	{
	  /* free item-list *and* all malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* done, return to Python with the dictionary */
	return ar_dict;
} /* vms_lib_set_logical () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
v = 255*'X'
while (1):
  dict = vms_lib.set_logical ('LNM_TEST', v)
# -while

-----

# -- check 2
import vms_lib
import vms_lnmdef
v = 255*'X'
# build an item-list
while (1):
  dict = vms_lib.set_logical('LNM_TEST',None,'LNM$GROUP',None,
      ( ('LNM$_ATTRIBUTES',vms_lnmdef.LNM_M_CONCEALED),
        ('LNM$_STRING','STA'),
        ('LNM$_ATTRIBUTES',0),
        ('LNM$_STRING','STB'),
        ('LNM$_TABLE',None)   # output item
      )
    )
# -while

-----

# -- check 3
import vms_lib
while (1):
  try:
    dict = vms_lib.set_logical('ERR')
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_SET_LOGICAL.C */
