/* VMS_LIB_TRIM_FILESPEC.C -- 27-OCT-1998 Uwe Zessin
   Python interface to LIB$TRIM_FILESPEC
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>	/* LIB$name  */
#include <libdef.h>		/* LIB$_name */
#include <ssdef.h>		/* SS$_name  */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_lib_gr_error;		/* exception vms_lib.error */
/* ------------------------------------------------------------------------- */

char vms_lib_trim_filespec__doc[] =
"status, new_filespec = vms_lib.trim_filespec (old_filespec [,width])\n\
Fit Long File Specification into Fixed Field.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_lib_trim_filespec (PyObject *self, PyObject *args)
{
	char			* at_old_filespec;
	struct dsc$descriptor_s   r_old_filespec;
	unsigned long		  l_old_filespec_len;

	struct dsc$descriptor     r_new_filespec;

	PyObject		* ar_word_integer_width;
	unsigned long		  l_word_integer_width;
	unsigned short int	  w_word_integer_width;
	unsigned short int	* aw_word_integer_width;

	unsigned short int	  w_resultant_length;

	unsigned long		  l_status_lib;
	unsigned long		  l_status_free;

	PyObject		* ar_return;

	/* -------------------- */
	ar_word_integer_width = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|O",
	    &at_old_filespec, &l_old_filespec_len,
	    &ar_word_integer_width))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: old-filespec */
	if (l_old_filespec_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	 "argument 1: old-filespec - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_old_filespec.dsc$w_length  = l_old_filespec_len;
	r_old_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_old_filespec.dsc$b_class   = DSC$K_CLASS_S;
	r_old_filespec.dsc$a_pointer = at_old_filespec;

	/* -------------------- */
	/* argument 2: word_integer_width */
	if (ar_word_integer_width == Py_None)
	{
	    w_word_integer_width  = 256;       /* omitted - provide a default */
	}
	else
	{
	    if (!PyInt_Check(ar_word_integer_width))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: width - must be integer or None");
		return NULL;
	    }
	    l_word_integer_width = PyInt_AsLong(ar_word_integer_width);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    /* ----- */
	    if (l_word_integer_width > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		    "argument 2: width - must be a positive 16-bit integer");
		return NULL;
	    }
	    w_word_integer_width  = l_word_integer_width;
	    aw_word_integer_width = &w_word_integer_width;
	}

	/* -------------------- */
	/* set up string descriptor */
	r_new_filespec.dsc$w_length  = 0;
	r_new_filespec.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_new_filespec.dsc$b_class   = DSC$K_CLASS_D; /* not _S !! */
	r_new_filespec.dsc$a_pointer = 0;

	/* allocate memory for dynamic string descriptor */
	l_status_lib = lib$sget1_dd(&w_word_integer_width, &r_new_filespec);
	if (l_status_lib != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_trim_filespec: LIB$SGET1_DD() failed");
	    (void) PyErr_Print();

	    PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
	    return NULL;
	}

	/* -------------------- */
	l_status_lib = lib$trim_filespec
		(&r_old_filespec
		,&r_new_filespec
		,&w_word_integer_width	/* optional */
		,&w_resultant_length
		);

	/* -------------------- */
	if ((l_status_lib == SS$_NORMAL) || (l_status_lib == LIB$_STRTRU))
	{
	    ar_return = Py_BuildValue ("ls#",
		l_status_lib,
		(w_resultant_length == 0) ? /* empty string? */
		(void*)&r_new_filespec    : /* non-NULL address */
		(void*)r_new_filespec.dsc$a_pointer
		,(unsigned int)w_resultant_length);
	}
	else
	{
	    ar_return = NULL;
	}

	/* deallocate memory of dynamic string descriptor */
	l_status_free = lib$sfree1_dd (&r_new_filespec);
	if (l_status_free != SS$_NORMAL)
	{
	    PyErr_SetString(PyExc_SystemError,
		"vms_lib_trim_filespec: LIB$SFREE1_DD() failed");
	    (void) PyErr_Print();

	    if (l_status_lib == SS$_NORMAL)
	    {
		l_status_lib = l_status_free;	/* fail anyway */
		Py_XDECREF(ar_return);
	    }
	}

	if ((l_status_lib == SS$_NORMAL) || (l_status_lib == LIB$_STRTRU))
	{
	    return ar_return;	/* (can be NULL) */
	}

	Py_XDECREF(ar_return);

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_lib_gr_error, 1, l_status_lib);
} /* vms_lib_trim_filespec () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_lib
old_filspec = 'NOD"USRNAM PASWD"::DEVIC:[DIR.SUB1.SUB2]NAM.TYP;123'
while (1):
  status, new_filespec = vms_lib.trim_filespec (old_filspec)
  width = len (old_filspec)
  s,n = vms_lib.trim_filespec (old_filspec, width)
  s,n = vms_lib.trim_filespec (old_filspec, 50)
  s,n = vms_lib.trim_filespec (old_filspec, 32)
  s,n = vms_lib.trim_filespec (old_filspec, 31)
  s,n = vms_lib.trim_filespec (old_filspec, 26)
  s,n = vms_lib.trim_filespec (old_filspec, 25)
  s,n = vms_lib.trim_filespec (old_filspec, 11)
  s,n = vms_lib.trim_filespec (old_filspec, 10)
  s,n = vms_lib.trim_filespec (old_filspec, 7)
  s,n = vms_lib.trim_filespec (old_filspec, 6)
  s,n = vms_lib.trim_filespec (old_filspec, 3)
  s,n = vms_lib.trim_filespec (old_filspec, 2) # LIB$_STRTRU
# -while

-----

# -- check 2
import vms_lib
old_filspec = 'X.X'
while (1):
  try:
    status, new_filespec = vms_lib.trim_filespec (old_filspec, 'ERR')
  except (TypeError):
    pass
  try:
    status, new_filespec = vms_lib.trim_filespec (0)
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_LIB_TRIM_FILESPEC.C */
