/* VMS_MAIL.C -- 23-MAY-1999 Uwe Zessin (ZE.)
   interface to (some) OpenVMS MAIL$ routines

   23-MAY-1999 ZE. -- add MAILFILE_BEGIN, MAILFILE_CLOSE, MAILFILE_END
   23-MAY-1999 ZE. -- add MAILFILE_COMPRESS, MAILFILE_INFO_FILE,
			MAILFILE_MODIFY, MAILFILE_OPEN, MAILFILE_PURGE_WASTE,
			MESSAGE_BEGIN, MESSAGE_COPY, MESSAGE_DELETE,
			MESSAGE_END, MESSAGE_GET, MESSAGE_INFO, MESSAGE_MODIFY,
			MESSAGE_SELECT,
   15-JUL-1999 ZE. -- FB- add <mail$routines.h>
*/

#include "python.h"
#include "vmsdef.h"

#include <maildef.h>		/* MAIL$_name */
#include <ssdef.h>		/* SS$_name   */

#include <descrip.h>

/* ---------------------------------------- */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if (__DECC_VER <= 50690003) /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
unsigned long mail$mailfile_begin       (__unknown_params);
unsigned long mail$mailfile_close       (__unknown_params);
unsigned long mail$mailfile_compress    (__unknown_params);
unsigned long mail$mailfile_end         (__unknown_params);
unsigned long mail$mailfile_info_file   (__unknown_params);
unsigned long mail$mailfile_modify      (__unknown_params);
unsigned long mail$mailfile_open        (__unknown_params);
unsigned long mail$mailfile_purge_waste (__unknown_params);

unsigned long mail$message_begin  (__unknown_params);
unsigned long mail$message_copy   (__unknown_params);
unsigned long mail$message_delete (__unknown_params);
unsigned long mail$message_end    (__unknown_params);
unsigned long mail$message_get    (__unknown_params);
unsigned long mail$message_info   (__unknown_params);
unsigned long mail$message_modify (__unknown_params);
unsigned long mail$message_select (__unknown_params);
#pragma __standard
#else /* __DECC_VER <= 50600000 */
#include <mail$routines.h>
#endif /* else: __DECC_VER <= 50600000 */
#endif /* __DECC */

/* ------------------------------------------------------------------------- */
/* reference to translation table for MAIL$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$MAILDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

PyObject *vms_mail_gr_error;		/* exception vms_mail.error */

static char vms_mail_doc__ [] =
"This is an interface to some OpenVMS MAIL$ routines.\n\
See the VMS_MAIL documentation for details.";

static char vms_mail_t_cant_init [] =
"can't initialize module vms_mail";

static char vms_mail_t_cant_deferr [] =
"can't define vms_mail.error";

/* a null-item list */
static struct vmsdef_xr_itmlst3 vmsmail_r_itmnull = {0,0,0,0};

/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */

/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------ */

/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

int vms_mail__process_args
	(PyObject			*   args
	,unsigned long			*   l_context
	,PyObject			**  ar_py_in_item_list
	,struct vmsdef_xr_itmlst3	**  ar_in_itemlist
	,unsigned short int		**  aw_in_retlenlist
	,struct vmsdef_xr_itmtbl	*** ar_in_itm_vmsdef
	,PyObject			**  ar_py_out_item_list
	,struct vmsdef_xr_itmlst3	**  ar_out_itemlist
	,unsigned short int		**  aw_out_retlenlist
	,struct vmsdef_xr_itmtbl	*** ar_out_itm_vmsdef
	)
{
	/* -------------------- */
	*l_context	     = 0;
	*ar_py_in_item_list  = Py_None;
	*ar_py_out_item_list = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l|OO",
	    &(* l_context),
	    &(* ar_py_in_item_list),
	    &(* ar_py_out_item_list) ))
	{
	    return -1;
	}

	/* -------------------- */
	/* argument 1: context */

	/* -------------------- */
	/* argument 2: in-item-list*/
	if ((* ar_py_in_item_list) == Py_None)
	{
	    *ar_in_itemlist = &vmsmail_r_itmnull;	/* omitted */
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$MAILDEF		/* VMSDEF_GR_$xxxDEF */
		,*ar_py_in_item_list		/* Python itmlst obj */
		,&(* ar_in_itemlist)	/* return VMS item list           */
		,&(* ar_in_itm_vmsdef)	/* return VMSDEF back-ptr array   */
		,&(* aw_in_retlenlist)	/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return -1;		/* item list build failed */
	    }
	} /* - if (*ar_py_in_item_list == Py_None) */

	/* -------------------- */
	/* argument 3: out-item-list*/
	if ((* ar_py_out_item_list) == Py_None)
	{
	    *ar_out_itemlist = &vmsmail_r_itmnull;	/* omitted */
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$MAILDEF		/* VMSDEF_GR_$xxxDEF */
		,*ar_py_out_item_list		/* Python itmlst obj */
		,&(* ar_out_itemlist)	/* return VMS item list           */
		,&(* ar_out_itm_vmsdef)	/* return VMSDEF back-ptr array   */
		,&(* aw_out_retlenlist)	/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		/* free item-list *and* all malloc()ed buffers */
		if ((* ar_py_in_item_list) != Py_None)
		{
		    (void) vms__itmlst_free(*ar_in_itemlist,
			*ar_in_itm_vmsdef, *aw_in_retlenlist);
		}
		return -1;		/* item list build failed */
	    }
	} /* - if (*ar_py_out_item_list == Py_None) */

	/* -------------------- */
	return 0;
} /* int vms_mail__process_args() */

/* ------------------------------------------------------------------------- */

PyObject * vms_mail__build_dict
	(unsigned long			   l_status
	,unsigned long			   l_context
	,PyObject			*  ar_py_out_item_list
	,struct vmsdef_xr_itmlst3	*  ar_out_itemlist
	,unsigned short int		*  aw_out_retlenlist
	,struct vmsdef_xr_itmtbl	** ar_out_itm_vmsdef
	)
{
	/* -------------------- */
	PyObject * ar_dict;	/* dictionary to be returned */
	PyObject * ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	/* create a dictionary because the user might have specified an */
	/*  output-item in the item-list */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    if (ar_py_out_item_list != Py_None)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_out_itemlist,
		    ar_out_itm_vmsdef, aw_out_retlenlist);
	    }
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    if (ar_py_out_item_list != Py_None)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_out_itemlist,
		    ar_out_itm_vmsdef, aw_out_retlenlist);
	    }
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) != 0)
	{
	    Py_DECREF(ar_dictobj);
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    if (ar_py_out_item_list != Py_None)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_out_itemlist,
		    ar_out_itm_vmsdef, aw_out_retlenlist);
	    }
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* put context into dictionary */
	ar_dictobj = PyInt_FromLong(l_context);
	if (ar_dictobj == NULL)
	{
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    if (ar_py_out_item_list != Py_None)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_out_itemlist,
		    ar_out_itm_vmsdef, aw_out_retlenlist);
	    }
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "context", ar_dictobj) != 0)
	{
	    Py_DECREF(ar_dictobj);
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    if (ar_py_out_item_list != Py_None)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_out_itemlist,
		    ar_out_itm_vmsdef, aw_out_retlenlist);
	    }
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* build remaining items only if 'success' */
	if ((l_status == SS$_NORMAL) ||
	    (l_status == 8322313)     ) /* MAIL$_MSGINFO */
	{
	  /* process item-list only if it was specified */
	  if (ar_py_out_item_list != Py_None)
	  {
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$MAILDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_out_itemlist	/* return VMS item list           */
		,&ar_out_itm_vmsdef	/* return VMSDEF back-ptr array   */
		,&aw_out_retlenlist	/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	  }
	} /* if (l_status == SS$_NORMAL) */

	/* -------------------- */
	if (ar_py_out_item_list != Py_None)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_out_itemlist,
		ar_out_itm_vmsdef, aw_out_retlenlist);
	}

	/* done, return to Python with the dictionary */
	return ar_dict;

} /* int vms_mail__build_dict() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_begin__doc[] =
"dict = vms_mail.mailfile_begin (context, [in_item_list], [out_item_list])\n\
Inititates mail file processing.";

PyObject *
vms_mail_mailfile_begin (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_BEGIN() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_BEGIN() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_begin
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_begin() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_close__doc[] =
"dict = vms_mail.mailfile_close (context, [in_item_list], [out_item_list])\n\
Closes the currently open mail file.";

PyObject *
vms_mail_mailfile_close (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_CLOSE() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_CLOSE() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_close
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_close() */
/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_compress__doc[] =
"dict = vms_mail.mailfile_compress (context, [in_item_list], [out_item_list])\n\
Compresses a mail file.";

PyObject *
vms_mail_mailfile_compress (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_COMPRESS() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_COMPRESS() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_compress
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_compress() */
/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_end__doc[] =
"dict = vms_mail.mailfile_end (context, [in_item_list], [out_item_list])\n\
Terminates mail file processing.";

PyObject *
vms_mail_mailfile_end (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_END() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_END() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_end
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_end() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_info_file__doc[] =
"dict = vms_mail.mailfile_info_file (context, [in_item_list], [out_item_list])\n\
Obtains information about a specified mail file.";

PyObject *
vms_mail_mailfile_info_file (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_INFO_FILE() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_INFO_FILE() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_info_file
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_info_file() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_modify__doc[] =
"dict = vms_mail.mailfile_modify (context, [in_item_list], [out_item_list])\n\
Modifies informational record of an indexed mail file.";

PyObject *
vms_mail_mailfile_modify (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_MODIFY() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_MODIFY() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_modify
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_modify() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_open__doc[] =
"dict = vms_mail.mailfile_open (context, [in_item_list], [out_item_list])\n\
Opens a specified mail file for processing.";

PyObject *
vms_mail_mailfile_open (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_OPEN() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_OPEN() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_open
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

/* @@ status MAIL$_NOMSGS */
	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_open() */

/* ------------------------------------------------------------------------- */

static char vms_mail_mailfile_purge_waste__doc[] =
"dict = vms_mail.mailfile_purge_waste (context, [in_item_list], [out_item_list])\n\
Deletes messages contained in the wastebasket..";

PyObject *
vms_mail_mailfile_purge_waste (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_PURGE_WASTE() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MAILFILE_PURGE_WASTE() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$mailfile_purge_waste
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

/* @@ status MAIL$_NORMAL */
	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_mailfile_purge_waste() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_begin__doc[] =
"dict = vms_mail.message_begin (context, [in_item_list], [out_item_list])\n\
Begins message processing.";

PyObject *
vms_mail_message_begin (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_BEGIN() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_BEGIN() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_begin
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_begin() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_copy__doc[] =
"dict = vms_mail.message_copy (context, [in_item_list], [out_item_list])\n\
Copies messages between files or folders.";

PyObject *
vms_mail_message_copy (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_COPY() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_COPY() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_copy
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

/* @@ stati:
SS$_NORMAL	Normal successful completion.
MAIL$_MSGINFO	Informational records are successfully returned.
MAIL$_MSGTEXT	Text record is successfully returned.
MAIL$_BADVALUE	The specified keyword value is invalid.
MAIL$_CONITMCOD The specified item codes define  conflicting operations.
MAIL$_DATIMUSED The date and time is currently used in the specified file.
MAIL$_DELMSG	The message is deleted.
MAIL$_NOMOREREC No more records can be found.
*/
	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_copy() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_delete__doc[] =
"dict = vms_mail.message_delete (context, [in_item_list], [out_item_list])\n\
Deletes a specified message from the currently selected folder.";

PyObject *
vms_mail_message_delete (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_DELETE() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_DELETE() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_delete
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_delete() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_end__doc[] =
"dict = vms_mail.message_end (context, [in_item_list], [out_item_list])\n\
Ends message processing.";

PyObject *
vms_mail_message_end (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_END() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_END() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_end
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_end() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_get__doc[] =
"dict = vms_mail.message_get (context, [in_item_list], [out_item_list])\n\
Ends message processing.";

PyObject *
vms_mail_message_get (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_GET() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_GET() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_get
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

/* @@ stati:
MAIL$_MSGINFO	Informational records are successfully returned.
MAIL$_MSGTEXT	Text record is successfully returned.
MAIL$_NOFILEOPEN The mail file is not open.
*/
	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_get() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_info__doc[] =
"dict = vms_mail.message_info (context, [in_item_list], [out_item_list])\n\
Obtains information about a specific message.";

PyObject *
vms_mail_message_info (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_INFO() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_INFO() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_info
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_info() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_modify__doc[] =
"dict = vms_mail.message_modify (context, [in_item_list], [out_item_list])\n\
Modifies information in the message header.";

PyObject *
vms_mail_message_modify (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_MODIFY() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_MODIFY() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_modify
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

/* @@ stati:
MAIL$_DELMSG	The message is deleted.
MAIL$_NOMOREMSG No more messages.
*/
	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_modify() */

/* ------------------------------------------------------------------------- */

static char vms_mail_message_select__doc[] =
"dict = vms_mail.message_select (context, [in_item_list], [out_item_list])\n\
Select a message or messages.";

PyObject *
vms_mail_message_select (PyObject *self, PyObject *args)
{
	unsigned long		l_context;

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_in_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_SELECT() */
	struct vmsdef_xr_itmlst3 * ar_in_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_in_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_in_itm_vmsdef;	/* start address */

	/* -------------------- */
	/* item-list - tuples of tuples = (('MAIL$_name',data), ...) */
	PyObject		* ar_py_out_item_list;

	/* VMS item-list to be passed to VMS_MAIL_MESSAGE_SELECT() */
	struct vmsdef_xr_itmlst3 * ar_out_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_out_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_out_itm_vmsdef;	/* start address */
	/* -------------------- */
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	unsigned long		   l_status;

	/* -------------------- */
	l_status = vms_mail__process_args
		(args
		,&l_context
		,&ar_py_in_item_list
		,&ar_in_itemlist
		,&aw_in_retlenlist
		,&ar_in_itm_vmsdef
		,&ar_py_out_item_list
		,&ar_out_itemlist
		,&aw_out_retlenlist
		,&ar_out_itm_vmsdef
		);

	if (l_status != 0)
	{
	    return NULL;
	}

	/* -------------------- */
	l_status = mail$message_select
		(&l_context
		,ar_in_itemlist
		,ar_out_itemlist
		);

	/* -------------------- */
	/* drop input-item list if specified */
	if (ar_py_in_item_list != Py_None)
	{
	    (void) vms__itmlst_free(ar_in_itemlist,
		ar_in_itm_vmsdef, aw_in_retlenlist);
	}

	/* -------------------- */
	ar_dict = vms_mail__build_dict
			(l_status
			,l_context
			,ar_py_out_item_list
			,ar_out_itemlist
			,aw_out_retlenlist
			,ar_out_itm_vmsdef
			);

	/* -------------------- */
	return ar_dict;

} /* vms_mail_message_select() */

/* ------------------------------------------------------------------------- */

static struct PyMethodDef vms_mail_methods[] = {
{"mailfile_begin",       (PyCFunction)vms_mail_mailfile_begin,       METH_VARARGS, vms_mail_mailfile_begin__doc},
{"mailfile_close",       (PyCFunction)vms_mail_mailfile_close,       METH_VARARGS, vms_mail_mailfile_close__doc},
{"mailfile_compress",    (PyCFunction)vms_mail_mailfile_compress,    METH_VARARGS, vms_mail_mailfile_compress__doc},
{"mailfile_end",         (PyCFunction)vms_mail_mailfile_end,         METH_VARARGS, vms_mail_mailfile_end__doc},
{"mailfile_info_file",   (PyCFunction)vms_mail_mailfile_info_file,   METH_VARARGS, vms_mail_mailfile_info_file__doc},
{"mailfile_modify",      (PyCFunction)vms_mail_mailfile_modify,      METH_VARARGS, vms_mail_mailfile_modify__doc},
{"mailfile_open",        (PyCFunction)vms_mail_mailfile_open,        METH_VARARGS, vms_mail_mailfile_open__doc},
{"mailfile_purge_waste", (PyCFunction)vms_mail_mailfile_purge_waste, METH_VARARGS, vms_mail_mailfile_purge_waste__doc},

{"message_begin",  (PyCFunction)vms_mail_message_begin,  METH_VARARGS, vms_mail_message_begin__doc},
{"message_copy",   (PyCFunction)vms_mail_message_copy,   METH_VARARGS, vms_mail_message_copy__doc},
{"message_delete", (PyCFunction)vms_mail_message_delete, METH_VARARGS, vms_mail_message_delete__doc},
{"message_end",    (PyCFunction)vms_mail_message_end,    METH_VARARGS, vms_mail_message_end__doc},
{"message_get",    (PyCFunction)vms_mail_message_get,    METH_VARARGS, vms_mail_message_get__doc},
{"message_info",   (PyCFunction)vms_mail_message_info,   METH_VARARGS, vms_mail_message_info__doc},
{"message_modify", (PyCFunction)vms_mail_message_modify, METH_VARARGS, vms_mail_message_modify__doc},
{"message_select", (PyCFunction)vms_mail_message_select, METH_VARARGS, vms_mail_message_select__doc},
{NULL,                 NULL}
};

void
initvms_mail()
{
	PyObject *m, *d;

	m = Py_InitModule4("vms_mail",
			   vms_mail_methods,
			   vms_mail_doc__,
			   (PyObject *)NULL,
			   PYTHON_API_VERSION);
	d = PyModule_GetDict(m);

	/* -------------------- */
        if (PyErr_Occurred())
	{
	    (void) Py_FatalError(vms_mail_t_cant_init);
	}

	/* -------------------- */
	/* Initialize exception */
	vms_mail_gr_error = PyErr_NewException("vms_mail.error", NULL, NULL);
	if (vms_mail_gr_error == NULL)
	{
	    (void) Py_FatalError(vms_mail_t_cant_deferr);
	}

	if (PyDict_SetItemString(d, "error", vms_mail_gr_error) != 0)
	{
	    (void) Py_FatalError(vms_mail_t_cant_deferr);
	}
} /* initvms_mail () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_MAIL.C */
