/* VMS_SYS_ADD_PROXY.C -- 21-JAN-1998 Uwe Zessin
   Python interface to SYS$ADD_PROXY()

   doc string (vms_sys_add_proxy__doc[]) in VMS_SYS.C
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_add_proxy__doc[] =
"vms_sys.add_proxy (rem_node, rem_user, local_user [,flags])\n\
Add or Modify Proxy.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_add_proxy (PyObject *self, PyObject *args)
{
	char			* at_rem_node;
	struct dsc$descriptor_s   r_rem_node;
	unsigned long		  l_rem_node_len;

	char			* at_rem_user;
	struct dsc$descriptor_s   r_rem_user;
	unsigned long		  l_rem_user_len;

	char			* at_local_user;
	struct dsc$descriptor_s   r_local_user;
	unsigned long		  l_local_user_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;

	unsigned long		  l_status;

	/* -------------------- */
	ar_flags = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#s#s#|O",
	    &at_rem_node,   &l_rem_node_len,
	    &at_rem_user,   &l_rem_user_len,
	    &at_local_user, &l_local_user_len,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: rem_node */
	if (l_rem_node_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 1: rem_node - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_node.dsc$w_length  = l_rem_node_len;
	r_rem_node.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_node.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_node.dsc$a_pointer = at_rem_node;

	/* -------------------- */
	/* argument 2: rem_user */
	if (l_rem_user_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 2: rem_user - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_user.dsc$w_length  = l_rem_user_len;
	r_rem_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_user.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_user.dsc$a_pointer = at_rem_user;

	/* -------------------- */
	/* argument 3: local_user */
	if (l_local_user_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	   "argument 3: local_user - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_local_user.dsc$w_length  = l_local_user_len;
	r_local_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_local_user.dsc$b_class   = DSC$K_CLASS_S;
	r_local_user.dsc$a_pointer = at_local_user;

	/* -------------------- */
	/* argument 4: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$add_proxy
		(&r_rem_node
		,&r_rem_user
		,&r_local_user
		,l_flags	/* by value */
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    Py_INCREF(Py_None);
	    return Py_None;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_add_proxy () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_ADD_PROXY.C */
