/* VMS_SYS_BRKTHRUW.C -- 13-AUG-1999 Uwe Zessin
   Python interface to SYS$BRKTHRUW()

Note: the [astadr] and [astprm] arguments are not implemented.
*/


#include "python.h"
#include "vmsdef.h"
#include "vmsobj_iosb.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */

char vms_sys_brkthruw__doc[] =
"status, iosb = vms_sys.brkthruw ([efn], msgbuf, [sendto], [sndtyp], [iosb],\
 [carcon], [flags], [reqid], [timout], [astadr], [astprm])\n\
Breakthrough and Wait.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_brkthruw (PyObject *self, PyObject *args)
{
	PyObject		* ar_efn;
	unsigned long		  l_efn;

	char			* at_msgbuf;
	struct dsc$descriptor_s   r_msgbuf;
	unsigned long		  l_msgbuf_len;

	char			* at_sendto;
	struct dsc$descriptor_s   r_sendto;
	struct dsc$descriptor_s	* ar_sendto;
	unsigned long		  l_sendto_len;

	PyObject		* ar_sndtyp;
	unsigned long		  l_sndtyp;

	vmsobj_iosb		* ar_py_iosb;
	long			* aq_vms_iosb;

	PyObject		* ar_carcon;
	unsigned long		  l_carcon;

	PyObject		* ar_flags;
	unsigned long		  l_flags;

	PyObject		* ar_reqid;
	unsigned long		  l_reqid;

	PyObject		* ar_timout;
	unsigned long		  l_timout;

	PyObject		* ar_astadr;	/* @@ ignored */

	PyObject		* ar_astprm;	/* @@ ignored */

	unsigned long		  l_status;

	/* -------------------- */
        at_sendto  = NULL;    l_sendto_len = 0;
	ar_sndtyp  = Py_None;
	ar_py_iosb = (vmsobj_iosb *)Py_None;
	ar_carcon  = Py_None;
	ar_flags   = Py_None;
	ar_reqid   = Py_None;
	ar_timout  = Py_None;
	ar_astadr  = Py_None;	/* @@ ignored */
	ar_astprm  = Py_None;	/* @@ ignored */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "Os#|z#OOOOOOO",
	    &ar_efn,
	    &at_msgbuf, &l_msgbuf_len,
	    &at_sendto, &l_sendto_len,
	    &ar_sndtyp,
	    &ar_py_iosb,
	    &ar_carcon,
	    &ar_flags,
	    &ar_reqid,
	    &ar_timout,
	    &ar_astadr,
	    &ar_astprm ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: efn */
	if (ar_efn == Py_None)
	{
	    l_efn = 0;			/* omitted - BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_efn))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: efn - must be integer or None");
		return NULL;
	    }
	    l_efn = PyInt_AsLong(ar_efn);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 2: msgbuf */
	if (l_msgbuf_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 2: msgbuf - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up descriptor */
	r_msgbuf.dsc$w_length  = l_msgbuf_len;
	r_msgbuf.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_msgbuf.dsc$b_class   = DSC$K_CLASS_S;
	r_msgbuf.dsc$a_pointer = at_msgbuf;

	/* -------------------- */
	/* argument 3: sendto */
	if (at_sendto == NULL)
	{
	    ar_sendto = 0;		/* omitted */
	}
	else
	{
	    if (l_sendto_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 3: sendto - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_sendto.dsc$w_length  = l_sendto_len;
	    r_sendto.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_sendto.dsc$b_class   = DSC$K_CLASS_S;
	    r_sendto.dsc$a_pointer = at_sendto;
	    ar_sendto = &r_sendto;
	}

	/* -------------------- */
	/* argument 4: sndtyp */
	if (ar_sndtyp == Py_None)
	{
	    l_sndtyp = 0;		/* BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_sndtyp))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: sndtyp - must be integer or None");
		return NULL;
	    }
	    l_sndtyp = PyInt_AsLong(ar_sndtyp);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 5: iosb */
	if (ar_py_iosb == (vmsobj_iosb *)Py_None)
	{
	    /* create a new vmsobj_iosb object */
	    ar_py_iosb = vmsobj_iosb_new (NULL);
	    if (ar_py_iosb == NULL)
	    {
	      return NULL;
	    }
	}
	else
	{
	    if (!vmsobj_iosb_Check(ar_py_iosb))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: iosb - must be vmsobj_iosb or None");
		return NULL;
	    }
	}
	aq_vms_iosb = ar_py_iosb->aq_iosb;

	/* -------------------- */
	/* argument 6: carcon */
	if (ar_carcon == Py_None)
	{
	    l_carcon = 0;		/* BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_carcon))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: carcon - must be integer or None");
		return NULL;
	    }
	    l_carcon = PyInt_AsLong(ar_carcon);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 7: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 7: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 8: reqid */
	if (ar_reqid == Py_None)
	{
	    l_reqid = 0;		/* BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_reqid))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 8: reqid - must be integer or None");
		return NULL;
	    }
	    l_reqid = PyInt_AsLong(ar_reqid);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 9: timout */
	if (ar_timout == Py_None)
	{
	    l_timout = 0;		/* BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_timout))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 9: timout - must be integer or None");
		return NULL;
	    }
	    l_timout = PyInt_AsLong(ar_timout);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 6: astadr - @@ ignored */

	/* -------------------- */
	/* argument 7: astprm - @@ ignored */

	/* -------------------- */
	l_status = sys$brkthruw
		(l_efn		/* [efn] - BY VALUE */
		,&r_msgbuf
		,ar_sendto
		,l_sndtyp
		,aq_vms_iosb
		,l_carcon
		,l_flags
		,l_reqid
		,l_timout
		,0		/* [astadr] @@ ignored */
		,0		/* [astprm] @@ ignored */
		);

	/* -------------------- */
	return Py_BuildValue ("lO", l_status, ar_py_iosb);
} /* vms_sys_brkthruw () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_BRKTHRUW.C */
