/* VMS_SYS_CREATE.C -- 26-FEB-1999 Uwe Zessin
   Python interface to SYS$CREATE()
*/


#include "python.h"

#include <starlet.h>		/* SYS$name, ... */

#include "vmsobj_fab.h"

/* ------------------------------------------------------------------------- */

char vms_sys_create__doc[] =
"status = vms_sys.create (fab, [err], [suc])\n\
Create File (RMS).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_create (PyObject *self, PyObject *args)
{
	vmsobj_fab		* ar_py_fab;
	struct FAB		* ar_vms_fab;

	PyObject		* ar_py_err;
	long			* al_err;

	PyObject		* ar_py_suc;
	long			* al_suc;

	unsigned long		  l_status;

	/* -------------------- */
	ar_py_err = Py_None;
	ar_py_suc = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O|OO",
	    &ar_py_fab,
	    &ar_py_err,
	    &ar_py_suc ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: fab */
	if (! vmsobj_fab_Check(ar_py_fab))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: fab - must be vmsobj_fab object");
	    return NULL;
	}
	ar_vms_fab = ar_py_fab->ab_fab;

	/* -------------------- */
	/* argument 2: err - ignored */
	al_err = 0;

	/* -------------------- */
	/* argument 3: suc - ignored */
	al_suc = 0;

	/* -------------------- */
	l_status = sys$create
		(ar_vms_fab	/* fab   */
		,al_err		/* [err] */
		,al_suc		/* [suc] */
		);

	/* -------------------- */
	return PyInt_FromLong(l_status);
} /* vms_sys_create () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_CREATE.C */
