/* VMS_SYS_CRELNT.C -- 16-OCT-1998 Uwe Zessin
   Python interface to SYS$CRELNT()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_crelnt__doc[] =
"status, resnam = vms_sys.crelnt ([attr], [quota], [promsk], [tabnam], partab,\
 [acmode])\n\
Create Logical Name Table.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_crelnt (PyObject *self, PyObject *args)
{
	PyObject		* ar_attr;
	unsigned long		  l_attr;
	unsigned long		* al_attr;

	PyObject		* ar_quota;
	unsigned long		  l_quota;
	unsigned long		* al_quota;

	PyObject		* ar_promsk;
	unsigned long		  l_promsk;
	unsigned short int	  w_promsk;
	unsigned short int	* aw_promsk;

	char			* at_tabnam;
	struct dsc$descriptor_s   r_tabnam;
	struct dsc$descriptor_s * ar_tabnam;
	long			  l_tabnam_len;

	char			* at_partab;
	struct dsc$descriptor_s   r_partab;
	unsigned long		  l_partab_len;

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;
	unsigned char		  b_acmode;
	unsigned char		* ab_acmode;

	char			  t_resnam[32];
	struct dsc$descriptor_s   r_resnam;
	unsigned short int	  w_reslen;

	unsigned long		  l_status;

	/* -------------------- */
	ar_acmode = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OOOz#s#|O",
	    &ar_attr,
	    &ar_quota,
	    &ar_promsk,
	    &at_tabnam, &l_tabnam_len,
	    &at_partab, &l_partab_len,
	    &ar_acmode ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: attr */
	if (ar_attr == Py_None)
	{
	    al_attr = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_attr))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: attr - must be integer or None");
		return NULL;
	    }
	    else
	    {
		l_attr  = PyInt_AsLong(ar_attr);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		al_attr = &l_attr;
	    }
	}

	/* -------------------- */
	/* argument 2: quota */
	if (ar_quota == Py_None)
	{
	    al_quota = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_quota))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: quota - must be integer or None");
		return NULL;
	    }
	    else
	    {
		l_quota  = PyInt_AsLong(ar_quota);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		al_quota = &l_quota;
	    }
	}

	/* -------------------- */
	/* argument 3: promsk */
	if (ar_promsk == Py_None)
	{
	    aw_promsk = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_promsk))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: promsk - must be 16-bit integer or None");
		return NULL;
	    }
	    else
	    {
		l_promsk = PyInt_AsLong(ar_promsk);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (l_promsk > 65535)
		{
		    PyErr_SetString(PyExc_TypeError,
		      "argument 3: promsk - must be 16-bit integer or None");
		    return NULL;
		}
		w_promsk  = (unsigned short int)l_promsk;
		aw_promsk = &w_promsk;
	    }
	}

	/* -------------------- */
	/* argument 4: tabnam */
	if (at_tabnam == NULL)
	{
	    ar_tabnam = 0;	/* omitted */
	}
	else
	{
	    if (l_tabnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 4: tabnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_tabnam.dsc$w_length  = l_tabnam_len;
	    r_tabnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_tabnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_tabnam.dsc$a_pointer = at_tabnam;
	    ar_tabnam = &r_tabnam;
	}

	/* -------------------- */
	/* argument 5: partab */
	if (at_partab == NULL)
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 5: partab - argument is not optional");
	    return NULL;
	}
	else
	{
	    if (l_partab_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 5: partab - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_partab.dsc$w_length  = l_partab_len;
	    r_partab.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_partab.dsc$b_class   = DSC$K_CLASS_S;
	    r_partab.dsc$a_pointer = at_partab;
	}

	/* -------------------- */
	/* argument 6: acmode */
	if (ar_acmode == Py_None)
	{
	    ab_acmode = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: acmode - must be 8-bit integer or None");
		return NULL;
	    }
	    else
	    {
		l_acmode = PyInt_AsLong(ar_acmode);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (l_acmode > 255)
		{
		    PyErr_SetString(PyExc_TypeError,
		       "argument 6: acmode - must be 8-bit integer or None");
		    return NULL;
		}
		b_acmode  = (unsigned char)l_acmode;
		ab_acmode = &b_acmode;
	    }
	}

	/* -------------------- */
	/* set up string descriptor */
	r_resnam.dsc$w_length  = sizeof (t_resnam);
	r_resnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_resnam.dsc$b_class   = DSC$K_CLASS_S;
	r_resnam.dsc$a_pointer = &t_resnam[0];

	/* -------------------- */
	l_status = sys$crelnt
			(al_attr
			,&r_resnam	/* write */
			,&w_reslen	/* write */
			,al_quota
			,aw_promsk
			,ar_tabnam
			,&r_partab	/* not optional */
			,ab_acmode
			);

	/* -------------------- */
	/* ease debugging (DBG> examine/ascid ) */
	r_resnam.dsc$w_length = w_reslen;

	/* -------------------- */
	if ( (l_status == SS$_NORMAL) || (l_status == SS$_LNMCREATED) ||
	     (l_status == SS$_SUPERSEDE)                                )
	{
	    return Py_BuildValue ("ls#",
			l_status,
			r_resnam.dsc$a_pointer, (unsigned int)w_reslen);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_crelnt () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_sys, vms_lnmdef
PSL_C_SUPER = 2
while (1):
  status, resnam = vms_sys.crelnt (vms_lnmdef.LNM_M_CONFINE, \
                   123, None, 'NEW_TABLE', 'LNM$PROCESS_DIRECTORY', \
                   PSL_C_SUPER)
  #
# -while

-----

# -- check 2
import vms_sys
while (1):
  try:
    dict = vms_sys.crelnt ('ERR')
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_CRELNT.C */
