/* VMS_SYS_CREPRC.C -- 12-OCT-1998 Uwe Zessin
   Python interface to SYS$CREPRC()

   23-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <pqldef.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;
/* ------------------------------------------------------------------------- */
/* reference to translation table for PQL$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$PQLDEF[];
/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

#if defined(__DECC) || defined(__DECCXX)
#pragma __member_alignment __save
#pragma __nomember_alignment	/* byte followed by longword ! */
#endif

struct vmsdef_xr_quota_list {
	unsigned char		b_quota_code;
	unsigned long		l_quota_value;
};

typedef struct vmsdef_xr_quota_list vmsdef_xr_quota_list;

#if defined(__DECC) || defined(__DECCXX)
#pragma __member_alignment __restore
#endif

/* ------------------------------------------------------------------------- */

char vms_sys_creprc__doc[] =
"pidadr = vms_sys.creprc ([image] ,[input] ,[output] ,[error] ,[prvadr]\
 ,[quota] ,[prcnam] ,[baspri] ,[uic] ,[mbxunt] ,[stsflg] )\n\
Create Process.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_creprc (PyObject *self, PyObject *args)
{
	unsigned long		  l_pidadr;

	char			* at_image;
	struct dsc$descriptor_s   r_image;
	struct dsc$descriptor_s * ar_image;
	unsigned long		  l_image_len;

	char			* at_input;
	struct dsc$descriptor_s   r_input;
	struct dsc$descriptor_s * ar_input;
	unsigned long		  l_input_len;

	char			* at_output;
	struct dsc$descriptor_s   r_output;
	struct dsc$descriptor_s * ar_output;
	unsigned long		  l_output_len;

	char			* at_error;
	struct dsc$descriptor_s   r_error;
	struct dsc$descriptor_s * ar_error;
	unsigned long		  l_error_len;

	PyObject		* ar_prvadr;
	long			  q_prvadr[2];
	long			* aq_prvadr;

	/* ----- */
	/* quota-list - tuple of tuples:		  */
	/*   (('PQL$_name',data), ('PQL$_name',data),...) */
	PyObject		* ar_py_quota_list;

	unsigned long		  l_qtalst_size;	/* number of tuples */
	unsigned long		  l_qtalst_idx;		/* index into "     */

	char			* at_quota_code;	/* "	       */
	unsigned char		  b_quota_code;		/* from VMSDEF */

	unsigned long		  l_trn_idx; /* into VMSDEF_GR_$PQLDEF[] */

	/* VMS quota-list to be passed to SYS$CREPRC() */
	struct vmsdef_xr_quota_list * ar_quota_list;	 /* start address */
	struct vmsdef_xr_quota_list * ar_quota_list_ptr; /* walk along    */

	PyObject* ar_tuple;	/* Python tuple returning all data elements */
				/*  of a single item */
	PyObject* ar_py_quota;	/* Python quota name element ('PQL$_name')   */
	PyObject* ar_py_data;	/* Python data element to be inserted in pql */

	unsigned long		  l_malloc_bytes;	/* for malloc() */
	/* ----- */

	char			* at_prcnam;
	struct dsc$descriptor_s   r_prcnam;
	struct dsc$descriptor_s * ar_prcnam;
	unsigned long		  l_prcnam_len;

	PyObject		* ar_baspri;
	unsigned long		  l_baspri;

	PyObject		* ar_uic;
	unsigned long		  l_uic;

	PyObject		* ar_mbxunt;
	unsigned long		  l_mbxunt;  /* w_ */

	PyObject		* ar_stsflg;
	unsigned long		  l_stsflg;

	unsigned long		  l_status;

	/* -------------------- */
	at_input         = NULL;  l_input_len  = 0;
	at_output        = NULL;  l_output_len = 0;
	at_error         = NULL;  l_error_len  = 0;
	ar_prvadr        = Py_None;
	ar_py_quota_list = Py_None;
	at_prcnam        = NULL;  l_prcnam_len = 0;
	ar_baspri        = Py_None;
	ar_uic           = Py_None;
	ar_mbxunt        = Py_None;
	ar_stsflg        = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "z#|z#z#z#OOz#OOOO",
	    &at_image,  &l_image_len,
	    &at_input,  &l_input_len,
	    &at_output, &l_output_len,
	    &at_error,  &l_error_len,
	    &ar_prvadr,
	    &ar_py_quota_list,
	    &at_prcnam, &l_prcnam_len,
	    &ar_baspri,
	    &ar_uic,
	    &ar_mbxunt,
	    &ar_stsflg ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: image */
	if (at_image == NULL)
	{
	    ar_image = 0;	/* omitted */
	}
	else
	{
	    if (l_image_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		"argument 1: image - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_image.dsc$w_length  = l_image_len;
	    r_image.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_image.dsc$b_class   = DSC$K_CLASS_S;
	    r_image.dsc$a_pointer = at_image;
	    ar_image = &r_image;
	}

	/* -------------------- */
	/* argument 2: input */
	if (at_input == NULL)
	{
	    ar_input = 0;	/* omitted */
	}
	else
	{
	    if (l_input_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		"argument 2: input - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_input.dsc$w_length  = l_input_len;
	    r_input.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_input.dsc$b_class   = DSC$K_CLASS_S;
	    r_input.dsc$a_pointer = at_input;
	    ar_input = &r_input;
	}

	/* -------------------- */
	/* argument 3: output */
	if (at_output == NULL)
	{
	    ar_output = 0;	/* omitted */
	}
	else
	{
	    if (l_output_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 3: output - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_output.dsc$w_length  = l_output_len;
	    r_output.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_output.dsc$b_class   = DSC$K_CLASS_S;
	    r_output.dsc$a_pointer = at_output;
	    ar_output = &r_output;
	}

	/* -------------------- */
	/* argument 4: error */
	if (at_error == NULL)
	{
	    ar_error = 0;	/* omitted */
	}
	else
	{
	    if (l_error_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		"argument 4: error - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_error.dsc$w_length  = l_error_len;
	    r_error.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_error.dsc$b_class   = DSC$K_CLASS_S;
	    r_error.dsc$a_pointer = at_error;
	    ar_error = &r_error;
	}

	/* -------------------- */
	/* argument 5: prvadr */
	if (ar_prvadr == Py_None)
	{
	    aq_prvadr = 0;		/* omitted */
	}
	else
	{
	    if (!PyLong_Check(ar_prvadr))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: prvadr - must be long integer or None");
		return NULL;
	    }
	    else
	    {
		l_status = vms__cvt_pylong2quad (ar_prvadr, &q_prvadr[0]);
		if (l_status != SS$_NORMAL)
		{
		    PyErr_SetString(PyExc_SystemError,
"argument 5: prvadr - vms__cvt_pylong2quad() failed converting from object");
		    return NULL;
		}
		aq_prvadr = &q_prvadr[0];
	    }
	}

	/* -------------------- */
	/* argument 6: quota (list) */
	/* code is after all other arguments to ease malloc/free() */

	/* -------------------- */
	/* argument 7: prcnam */
	if (at_prcnam == NULL)
	{
	    ar_prcnam = 0;	/* omitted */
	}
	else
	{
	    if (l_prcnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 7: prcnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_prcnam.dsc$w_length  = l_prcnam_len;
	    r_prcnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_prcnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_prcnam.dsc$a_pointer = at_prcnam;
	    ar_prcnam = &r_prcnam;
	}

	/* -------------------- */
	/* argument 8: baspri */
	if (ar_baspri == Py_None)
	{
	    l_baspri = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_baspri))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 8: baspri - must be integer or None");
		return NULL;
	    }
	    else
	    {
		l_baspri = PyInt_AsLong(ar_baspri);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
	    }
	}

	/* -------------------- */
	/* argument 9: uic */
	if (ar_uic == Py_None)
	{
	    l_uic = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_uic))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 9: uic - must be integer or None");
		return NULL;
	    }
	    else
	    {
		l_uic = PyInt_AsLong(ar_uic);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
	    }
	}

	/* -------------------- */
	/* argument 10: mbxunt */
	if (ar_mbxunt == Py_None)
	{
	    l_mbxunt = 0;		/* omitted, use default  */
	}
	else
	{
	    if (!PyInt_Check(ar_mbxunt))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 10: mbxunt - must be 16-bit integer or None");
		return NULL;
	    }
	    else
	    {
		l_mbxunt = PyInt_AsLong(ar_mbxunt);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
		if (l_mbxunt > 65535)
		{
		    PyErr_SetString(PyExc_TypeError,
		     "argument 10: mbxunt - must be 16-bit integer or None");
		    return NULL;
		}
	    }
	}

	/* -------------------- */
	/* argument 11: stsflg */
	if (ar_stsflg == Py_None)
	{
	    l_stsflg = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_stsflg))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 9: stsflg - must be integer or None");
		return NULL;
	    }
	    else
	    {
		l_stsflg = PyInt_AsLong(ar_stsflg);
		if (PyErr_Occurred())
		{
		    return NULL;
		}
	    }
	}
/* -------------------- -------------------- -------------------- */

/* argument 6: quota */
if (ar_py_quota_list == Py_None)
{
    ar_quota_list = 0;		/* omitted */
}
else
{
    if (!PyTuple_Check(ar_py_quota_list))
    {
	PyErr_SetString(PyExc_TypeError,
	    "argument 6: quota-list - must be a tuple of tuples");
	return NULL;
    }

    l_qtalst_size = PyTuple_Size(ar_py_quota_list);

    /* ---------------------------------------- */
    /* allocate memory for:
    ||	- each item-list element
    ||	- the item-list termination element
    */
    l_malloc_bytes =
	( (l_qtalst_size * sizeof(struct vmsdef_xr_quota_list))+ /* items */
	  sizeof(vmsdef_xr_quota_list)	 /* termination of quota-list */
	);
    ar_quota_list = malloc (l_malloc_bytes);
    if (ar_quota_list == NULL)
    {
	return PyErr_NoMemory();
    }
    /* Set the allocated memory to 0. */
    (void) memset (ar_quota_list, 0, l_malloc_bytes);
    /* ar_quota_list_ptr is used to walk along the individual elements */
    /*  in the VMS quota-list */
    ar_quota_list_ptr = ar_quota_list;

    /* -------------------- */
    /* loop over quota-list */
    for (l_qtalst_idx = 0; l_qtalst_idx < l_qtalst_size; l_qtalst_idx++)
    {
	/* get a quota-tuple from the quota-list */
	ar_tuple = PyTuple_GetItem(ar_py_quota_list, l_qtalst_idx);
	if (PyErr_Occurred())
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return NULL;
	}
	/* -------------------- */
	/* must be a tuple ('PQL$_name',integer) */
	if (!PyTuple_Check(ar_tuple))
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return PyErr_Format(PyExc_TypeError,
"argument 6: quota-list - item:%d must be a tuple ('PQL$_name',integer)",
	    l_qtalst_idx);
	}

	/* -------------------- */
	/* get quota-string from quota-tuple */
	ar_py_quota = PyTuple_GetItem(ar_tuple, 0);
	if (PyErr_Occurred())
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return NULL;
	}
	/* quota-code must be a string ('PQL$_name') */
	if (!PyString_Check(ar_py_quota))
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return PyErr_Format(PyExc_TypeError,
	 "argument 6: quota-list - item:%d quota-code must be string",
	    l_qtalst_idx);
	}

	/* -------------------- */
	/* convert quota-code string to PQL$_ numerical value */
	l_trn_idx     = 0;
	at_quota_code = PyString_AS_STRING(ar_py_quota);
	while (VMSDEF_GR_$PQLDEF[l_trn_idx].w_vmsvermin != 0)
	{
	    /* check VMS version */
	    if ((VMSDEF_GR_$PQLDEF[l_trn_idx].w_vmsvermin <= vmsdef_gw_vmsver) &&
		(VMSDEF_GR_$PQLDEF[l_trn_idx].w_vmsvermax >= vmsdef_gw_vmsver)  )
	    {
	      /* compare quota name */
	      if (strcmp(at_quota_code ,VMSDEF_GR_$PQLDEF[l_trn_idx].at_itmnam_py) == 0)
	      {
		/* found textual match - use numerical value of quota-code */
		b_quota_code = (unsigned char)VMSDEF_GR_$PQLDEF[l_trn_idx].w_itmcod;
		break;				/* leave while() loop */
	      } /* quota-code string match */
	    } /* w_vmsvermin / w_vmsvermax match with vmsdef_gw_vmsver */
	    l_trn_idx++;				/* check next quota code */
	} /* while (VMSDEF_GR_$PQLDEF[l_trn_idx].w_vmsvermin != 0) */
	
	/* ---------------------------------------- */
	if (VMSDEF_GR_$PQLDEF[l_trn_idx].w_vmsvermin == 0)
	{
	    /* quota code not found - abort */
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return PyErr_Format(PyExc_ValueError,
		"argument 6: quota-list - unknown quota code: %.100s",
		at_quota_code);
	}

	/* ---------------------------------------- */
	/* printf ("@@qta:%s=%d\n", PyString_AS_STRING(ar_py_quota_code),  (int)b_quota_code); */

	/* store numerical quota-code into VMS quota-list */
	ar_quota_list_ptr->b_quota_code = b_quota_code;

	/* ------------------------------------- */
	/* get quota-value from quota-tuple */
	ar_py_data = PyTuple_GetItem(ar_tuple, 1);
	if (PyErr_Occurred())
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return NULL;
	}
	/* @@ quota-value must be an integer */
	/* @@  (currently hard-coded and VMSDEF (BWL) ignored) */
	if (!PyInt_Check(ar_py_data))
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	    return PyErr_Format(PyExc_TypeError,
       "argument 6: quota-list - item:%d quota-value must be integer");
	}

	/* store quota-value into VMS quota-list */
	ar_quota_list_ptr->l_quota_value = PyInt_AsLong(ar_py_data);

	/* ---------------------------------------- */
	ar_quota_list_ptr++;		/* next address of quota-list element  */
    } /* for (l_qtalst_idx = 0; l_qtalst_idx < l_qtalst_size; .. */

    /* terminate VMS quota-list - even if user specified termination */
    ar_quota_list_ptr->b_quota_code  = PQL$_LISTEND;
    ar_quota_list_ptr->l_quota_value = 0;
} /* - (ar_py_quota_list == Py_None) */

/* -------------------- -------------------- -------------------- */

	/* -------------------- */
	l_status = sys$creprc
			(&l_pidadr
			,ar_image
			,ar_input
			,ar_output
			,ar_error
			,aq_prvadr
			,ar_quota_list
			,ar_prcnam
			,l_baspri	/* by value */
			,l_uic		/* by value */
			,l_mbxunt	/* by value */
			,l_stsflg	/* by value */
			);

	/* -------------------- */
	/* release quota-list if it was specified */
	if (ar_quota_list != NULL)
	{
	    (void) free(ar_quota_list);		/* free VMS quota-list */
	}

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    /* no error - return -pidadr- to Python */
	    return PyInt_FromLong(l_pidadr);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_creprc () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_CREPRC.C */
