/* VMS_SYS_DASSGN.C -- 29-NOV-1998 Uwe Zessin
   Python interface to SYS$DASSGN()
*/

/* ------------------------------------------------------------ */

#include "python.h"
#include "vmsdef.h"

#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* exception object in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_dassgn__doc[] =
"vms_sys.dassgn (chan)\n\
Deassign I/O Channel.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_dassgn (PyObject *self, PyObject *args)
{
	unsigned long		  l_chan;
	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l", &l_chan))
	{
	    return NULL;
	}

	/* -------------------- */
	if (l_chan > 65535)
	{
	    PyErr_SetString(PyExc_TypeError,
	        "argument 1: chan - must be 16-bit positive integer");
	    return NULL;
	}

	/* -------------------- */
	l_status = sys$dassgn (l_chan);	/* by value */

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    Py_INCREF(Py_None);
	    return Py_None;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_dassgn () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DASSGN.C */
