/* VMS_SYS_DELETE_INTRUSION.C -- 31-MAY-1999 Uwe Zessin
   Python interface to SYS$DELETE_INTRUSION()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_delete_intrusion__doc[] =
"vms_sys.delete_intrusion (user_criteria, [flags])\n\
Delete Intrusion Record.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_delete_intrusion (PyObject *self, PyObject *args)
{
	char			* at_user_criteria;
	struct dsc$descriptor_s   r_user_criteria;
	unsigned long		  l_user_criteria_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* by value */

	unsigned long		  l_status;

	/* -------------------- */
	ar_flags = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|O",
	    &at_user_criteria, &l_user_criteria_len,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user_criteria */
	if (at_user_criteria == NULL)
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: user_criteria - argument is not optional");
	    return NULL;
	}
	else
	{
	    if (l_user_criteria_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	"argument 1: user_criteria - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_user_criteria.dsc$w_length  = l_user_criteria_len;
	    r_user_criteria.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_user_criteria.dsc$b_class   = DSC$K_CLASS_S;
	    r_user_criteria.dsc$a_pointer = at_user_criteria;
	}

	/* -------------------- */
	/* argument 2: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$delete_intrusion
			(&r_user_criteria
			,l_flags		/* by value */
			);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    Py_INCREF(Py_None);
	    return Py_None;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_delete_intrusion () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DELETE_INTRUSION.C */
