/* VMS_SYS_DEQ.C -- 30-MAY-1999 Uwe Zessin
   Python interface to SYS$DEQ()
*/


#include "python.h"
#include "vmsdef.h"

#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------ */
/* input a binary quadword - output a Python long integer */
PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------------------------------------------------- */

char vms_sys_deq__doc[] =
"status, valblk = vms_sys.deq ([lkid] ,[valblk] ,[acmode] ,[flags])\n\
Dequeue Lock Request.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_deq (PyObject *self, PyObject *args)
{
	PyObject		* ar_lkid;
	unsigned long		  l_lkid;	/* BY VALUE */

	PyObject		* ar_valblk;
	long			  q_valblk[2];
	long			* aq_valblk;

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;	/* BY VALUE */

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* BY VALUE */

	unsigned long		  l_status;
	PyObject		* ar_valblk_return;

	/* -------------------- */
	ar_lkid   = Py_None;
	ar_valblk = Py_None;
	ar_acmode = Py_None;
	ar_flags  = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|OOOO",
		&ar_lkid,
		&ar_valblk,
		&ar_acmode,
		&ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: lkid */
	if (ar_lkid == Py_None)
	{
	    l_lkid = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_lkid))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: lkid - must be integer or None");
		return NULL;
	    }
	    l_lkid = PyInt_AsLong(ar_lkid);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 2: valblk */
	if (ar_valblk == Py_None)
	{
	    aq_valblk = 0;
	    q_valblk[0] = 0;	/* data is always returned */
	    q_valblk[1] = 0;	/* data is always returned */
	}
	else
	{
	    if (!PyLong_Check(ar_valblk))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: valblk - must be long integer or None");
		return NULL;
	    }
	    /* convert Python long integer to binary quadword */
	    l_status = vms__cvt_pylong2quad (ar_valblk, &q_valblk[0]);
	    if (l_status == -1)
	    {
		return NULL;		/* error string has been set */
	    }
	    aq_valblk = &q_valblk[0];
	}

	/* -------------------- */
	/* argument 3: acmode */
	if (ar_acmode == Py_None)
	{
	    l_acmode = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: acmode - must be integer or None");
		return NULL;
	    }
	    l_acmode = PyInt_AsLong(ar_acmode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 4: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$deq
			(l_lkid		/* BY VALUE */
			,aq_valblk
			,l_acmode	/* BY VALUE */
			,l_flags	/* BY VALUE */
			);

	/* -------------------- */
	/* convert value-block back to python object */
	ar_valblk_return = vms__cvt_quad2pylong (&q_valblk[0]);
	if (ar_valblk_return == NULL)
	{
	    return NULL;
	}

	/* -------------------- */
	/* done, return to Python */
	return Py_BuildValue ("lO", l_status, ar_valblk_return);
	
} /* vms_sys_deq () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DEQ.C */
