/* VMS_SYS_DEVICE_SCAN.C -- 06-OCT-1998 Uwe Zessin
   Python interface to SYS$DEVICE_SCAN()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */
/* reference to translation table for DVS$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$DVSDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------ */
/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------------------------------------------------- */

char vms_sys_device_scan__doc[] =
"return_devnam, contxt = vms_sys.device_scan\
([search_devnam], [itmlst}, [contxt])\n\
Scan for Devices.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_device_scan (PyObject *self, PyObject *args)
{
	char			* at_search_devnam;
	struct dsc$descriptor_s   r_search_devnam;
	struct dsc$descriptor_s * ar_search_devnam;
	unsigned long		  l_search_devnam_len;

	PyObject		* ar_contxt_inp;
	PyObject		* ar_contxt_out;
	long			  q_contxt[2];
	long			* aq_contxt;

	/* item-list - tuple of tuples:                    */
	/*  ( ('DVS$_name',data), ('DVS$_name',data), ...) */
	PyObject		* ar_py_item_list;

#define S_RETURN_DEVNAM 64  /* no trailing \0 !! */
	char			   t_return_devnam[S_RETURN_DEVNAM];
	struct dsc$descriptor_s    r_return_devnam;
	unsigned short int	   w_retlen;

	/* VMS item-list to be passed to SYS$DEVICE_SCAN() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl * * ar_itm_vmsdef;	/* start address */

	unsigned long		    l_status;

	PyObject		  * ar_return_devnam;

	/* -------------------- */
	at_search_devnam = NULL;
	ar_py_item_list  = Py_None;
	ar_contxt_inp    = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|z#OO",
	    &at_search_devnam, &l_search_devnam_len,
	    &ar_py_item_list,
	    &ar_contxt_inp))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: search_devnam */
	if (at_search_devnam == NULL)
	{
	    ar_search_devnam = 0;	/* omitted */
	}
	else
	{
	    if (l_search_devnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	"argument 1: search-devnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_search_devnam.dsc$w_length  = l_search_devnam_len;
	    r_search_devnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_search_devnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_search_devnam.dsc$a_pointer = at_search_devnam;
	    ar_search_devnam = &r_search_devnam;
	}

	/* -------------------- */
	/* argument 3: contxt */
	if (ar_contxt_inp == Py_None)
	{
	    aq_contxt = 0;		/* omitted */
	}
	else
	{
	    if (!PyLong_Check(ar_contxt_inp))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: contxt - must be long integer or None");
		return NULL;
	    }
	    else
	    {
		l_status = vms__cvt_pylong2quad (ar_contxt_inp, &q_contxt[0]);
		if (l_status != SS$_NORMAL)
		{
		    PyErr_SetString(PyExc_SystemError,
  "argument 3: contxt - vms__cvt_pylong2quad() failed converting from object");
		    return NULL;
		}
		aq_contxt = &q_contxt[0];
	    }
	}

	/* -------------------- */
	/* argument 2: itmlst */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist = 0;			/* item list omitted */
	}
	else
	{
	    PyObject * ar_xxx; /* @@ ?? */

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,0				/* output-item bit   */
		,&VMSDEF_GR_$DVSDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	} /* else - (ar_py_item_list == Py_None)) */

	/* -------------------- */
	/* build string descriptor for return */
	r_return_devnam.dsc$w_length  = S_RETURN_DEVNAM;
	r_return_devnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_return_devnam.dsc$b_class   = DSC$K_CLASS_S;
	r_return_devnam.dsc$a_pointer = &t_return_devnam[0];

	/* -------------------- */
	l_status = sys$device_scan
		(&r_return_devnam	/* return_devnam	*/
		,&w_retlen		/* retlen		*/
		,ar_search_devnam	/* [search_devnam]	*/
		,ar_itemlist		/* [itmlst]		*/
		,aq_contxt		/* [contxt]		*/
		);

	/* -------------------- */
	if (ar_itemlist != 0)		/* itmlst argument was specified */
	{
	    /* always free memory - */
	    /* no matter if system service succeeded or not! */

	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    PyObject * ar_return;

	    /* update string descriptor to ease debugging DBG> EXA/ASCID */
	    r_return_devnam.dsc$w_length = w_retlen;

	    ar_return_devnam = Py_BuildValue("s#",
		r_return_devnam.dsc$a_pointer, (unsigned int)w_retlen);
	    if (ar_return_devnam == NULL)
	    {
		return NULL;
	    }

	    /* return updated contxt, if it was specified - 'None' otherwise */
	    if (aq_contxt == 0)
	    {
		ar_contxt_out = Py_None; /* not specified, return 'None' */
		Py_INCREF(ar_contxt_out);

	    }
	    else
	    {
		/* convert updated contxt quadword to Python long integer */
		ar_contxt_out = vms__cvt_quad2pylong (aq_contxt);
		if (ar_contxt_out == NULL)
		{
		    Py_DECREF(ar_return_devnam);
		    return NULL;
		}
	    }

	    /* return with tuple */
	    ar_return = Py_BuildValue ("OO", ar_return_devnam, ar_contxt_out);
	    Py_DECREF(ar_return_devnam);
	    Py_DECREF(ar_contxt_out);

	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_device_scan () */

/* ------------------------------------------------------------------------- */

/* ----------

# memory-leak test 1:
import vms_sys
while (1):
  ctx = 0L
  try:
    while (1):
      dev, ctx = vms_sys.device_scan('*',None,ctx)
  except (vms_sys.error):
    print '.',
    pass
# -while

# ----------

# memory-leak test 2:
import vms_sys
while (1):
  dev, ctx = vms_sys.device_scan('*')
# -while

# ----------

# memory-leak test 3:
import vms_sys
while (1):
  try:
    dev, ctx = vms_sys.device_scan(0)
  except (TypeError):
    pass
# -while

---------- */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DEVICE_SCAN.C */
