/* VMS_SYS_DISMOU.C -- 12-JAN-1999 Uwe Zessin
   Python interface to SYS$DISMOU()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */
#include <stsdef.h>		/* STS$_name	 */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_dismou__doc[] =
"vms_sys.dismou (devnam [,flags])\n\
Dismount Volume.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_dismou (PyObject *self, PyObject *args)
{
	char			* at_devnam;
	struct dsc$descriptor_s   r_devnam;
	unsigned long		  l_devnam_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;		/* by value */

	unsigned long		  l_status;

	/* -------------------- */
	ar_flags = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|O",
	    &at_devnam, &l_devnam_len,
	    &ar_flags))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: devnam */
	if (l_devnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: devnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_devnam.dsc$w_length  = l_devnam_len;
	r_devnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_devnam.dsc$b_class   = DSC$K_CLASS_S;
	r_devnam.dsc$a_pointer = at_devnam;

	/* -------------------- */
	/* argument 2: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* omitted - by value */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$dismou
		(&r_devnam	/* devnam		*/
		,l_flags	/* [flags] - by value	*/
		);

	/* -------------------- */
	l_status &= (~ STS$M_INHIB_MSG);	/* clear message inhibit */
	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    Py_INCREF(Py_None);
	    return Py_None;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_dismou () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DISMOU.C */
