/* VMS_SYS_DISPLAY_PROXY.C -- 21-JAN-1998 Uwe Zessin
   Python interface to SYS$DISPLAY_PROXY()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_display_proxy__doc[] =
"proxy_node, proxy_user, default_user, (local_users), context = \
vms_sys.display_proxy (rem_node, rem_user, flags [,context])\n\
Display Proxy Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_display_proxy (PyObject *self, PyObject *args)
{
	char			* at_rem_node;
	struct dsc$descriptor_s   r_rem_node;
	unsigned long		  l_rem_node_len;

	char			* at_rem_user;
	struct dsc$descriptor_s   r_rem_user;
	unsigned long		  l_rem_user_len;

	unsigned short int	  w_buffer_sizes[4];
#define K_PROXY_USER_LEN   0
#define K_PROXY_NODE_LEN   1
#define K_LOCAL_USERS_CNT  2
#define K_DEFAULT_USER_LEN 3

#define S_PROXY_NODE 1024
	char			  t_proxy_node[S_PROXY_NODE];
	struct dsc$descriptor_s   r_proxy_node;

#define S_PROXY_USER 32
	char			  t_proxy_user[S_PROXY_USER];
	struct dsc$descriptor_s   r_proxy_user;

#define S_DEFAULT_USER 32
	char			  t_default_user[S_DEFAULT_USER];
	struct dsc$descriptor_s   r_default_user;

struct vsdp_xr_local_users {
	unsigned short int	w_usrnam_len;
	unsigned short int	w_unused;
	char			t_username[32];
};
typedef struct vsdp_xr_local_users vsdp_xr_local_users;

	struct vsdp_xr_local_users r_local_users[17];

	PyObject		* ar_flags;
	unsigned long		  l_flags;

	PyObject		* ar_context;
	unsigned long		  l_context;
	unsigned long		* al_context;

	unsigned long		  l_status;

	/* -------------------- */
	ar_context = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#s#|OO",
	    &at_rem_node,   &l_rem_node_len,
	    &at_rem_user,   &l_rem_user_len,
	    &ar_flags,
	    &ar_context ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: rem_node */
	if (l_rem_node_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 1: rem_node - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_node.dsc$w_length  = l_rem_node_len;
	r_rem_node.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_node.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_node.dsc$a_pointer = at_rem_node;

	/* -------------------- */
	/* argument 2: rem_user */
	if (l_rem_user_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 2: rem_user - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_user.dsc$w_length  = l_rem_user_len;
	r_rem_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_user.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_user.dsc$a_pointer = at_rem_user;

	/* -------------------- */
	/* argument 3: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: flags - must be integer or None");
		return NULL;
	    }
	    l_flags  = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 4: context */
	if (ar_context == Py_None)
	{
	    al_context = 0;	/* omitted, BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: context - must be integer or None");
		return NULL;
	    }
	    l_context = PyInt_AsLong(ar_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_context = &l_context;
	}

	/* -------------------- */
	/* set up descriptors */
	r_proxy_node.dsc$w_length  = S_PROXY_NODE;
	r_proxy_node.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_proxy_node.dsc$b_class   = DSC$K_CLASS_S;
	r_proxy_node.dsc$a_pointer = &t_proxy_node[0];

	r_proxy_user.dsc$w_length  = S_PROXY_USER;
	r_proxy_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_proxy_user.dsc$b_class   = DSC$K_CLASS_S;
	r_proxy_user.dsc$a_pointer = &t_proxy_user[0];

	r_default_user.dsc$w_length  = S_DEFAULT_USER;
	r_default_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_default_user.dsc$b_class   = DSC$K_CLASS_S;
	r_default_user.dsc$a_pointer = &t_default_user[0];

	/* -------------------- */
	l_status = sys$display_proxy
		(&r_rem_node
		,&r_rem_user
		,&w_buffer_sizes
		,&r_proxy_node
		,&r_proxy_user
		,&r_default_user
		,&r_local_users
		,l_flags	/* by value */
		,al_context
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    PyObject	  * ar_return;
	    PyObject	  * ar_strobj;
	    PyObject	  * ar_local_users;
	    unsigned long   l_tuple_idx;

	    if (w_buffer_sizes[K_LOCAL_USERS_CNT] > 0)
	    {
		ar_local_users = PyTuple_New
		    ((unsigned long)w_buffer_sizes[K_LOCAL_USERS_CNT]);
		if (ar_local_users == NULL)
		{
		    return NULL;
		}
		for (l_tuple_idx = 0
		    ;l_tuple_idx < w_buffer_sizes[K_LOCAL_USERS_CNT]
		    ;l_tuple_idx++ )
		{
		    ar_strobj = Py_BuildValue ("s#"
			,&r_local_users[l_tuple_idx].t_username[0]
			,(unsigned int)r_local_users[l_tuple_idx].w_usrnam_len
			);
		    if (ar_strobj == NULL)
		    {
			Py_DECREF (ar_local_users);
			return NULL;
		    }
		    if (PyTuple_SetItem(ar_local_users,l_tuple_idx,ar_strobj)
			< 0)
		    {
			Py_DECREF (ar_local_users);
			Py_DECREF (ar_strobj);
			return NULL;
		    }
		}
	    }
	    else
	    {
		ar_local_users = Py_None;
		Py_INCREF (ar_local_users);
	    }

	    ar_return = Py_BuildValue ("s#s#s#Oi",
			&t_proxy_node[0],
			    (unsigned int)w_buffer_sizes[K_PROXY_NODE_LEN],
			&t_proxy_user[0],
			    (unsigned int)w_buffer_sizes[K_PROXY_USER_LEN],
			&t_default_user[0],
			    (unsigned int)w_buffer_sizes[K_DEFAULT_USER_LEN],
			ar_local_users,
			l_context );
	    Py_DECREF (ar_local_users);

	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_display_proxy () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_DISPLAY_PROXY.C */

