/* VMS_SYS_ENQW.C -- 29-MAY-1999 Uwe Zessin
   Python interface to SYS$ENQW()

Note: the [astadr], [astprm] and [blkast] arguments are not implemented.
*/


#include "python.h"
#include "vmsdef.h"
#include "vmsobj_lksb.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */

char vms_sys_enqw__doc[] =
"dict = vms_sys.enqw ([efn] ,lkmode ,lksb ,[flags] ,[resnam] ,[parid]\
 ,[astadr] ,[astprm] ,[blkast] ,[acmode] ,[rsdm_id])\n\
Enqueue Lock Request.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_enqw (PyObject *self, PyObject *args)
{
	PyObject		* ar_efn;
	unsigned long		  l_efn;	/* BY VALUE */
	unsigned long		  l_lkmode;	/* BY VALUE */

	vmsobj_lksb		* ar_py_lksb;
	struct vmsdef_xr_lksb	* ar_vms_lksb;
	long			  l_lksb_alloc;

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* BY VALUE */

	char			* at_resnam;
	struct dsc$descriptor_s   r_resnam;
	struct dsc$descriptor_s * ar_resnam;
	unsigned long		  l_resnam_len;

	PyObject		* ar_parid;
	unsigned long		  l_parid;	/* BY VALUE */

	PyObject		* ar_astadr;	/* @@ ignored */
	PyObject		* ar_astprm;	/* @@ ignored */
	PyObject		* ar_blkast;	/* @@ ignored */

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;	/* BY VALUE */

	PyObject		* ar_rdsm_id;
	unsigned long		  l_rdsm_id;	/* BY VALUE */

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	ar_efn     = Py_None;
	l_lkmode   = 0;
	ar_py_lksb = (vmsobj_lksb *)Py_None;
	ar_flags   = Py_None;
	at_resnam  = NULL;    l_resnam_len = 0;
	ar_parid   = Py_None;
	ar_astadr  = Py_None;			/* @@ ignored */
	ar_astprm  = Py_None;			/* @@ ignored */
	ar_blkast  = Py_None;			/* @@ ignored */
	ar_acmode  = Py_None;
	ar_rdsm_id = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "Ol|OOz#OOOOOO",
	    &ar_efn,
	    &l_lkmode,
	    &ar_py_lksb,
	    &ar_flags,
	    &at_resnam, &l_resnam_len,
	    &ar_parid,
	    &ar_astadr,			/* @@ ignored */
	    &ar_astprm,			/* @@ ignored */
	    &ar_blkast,			/* @@ ignored */
	    &ar_acmode,
	    &ar_rdsm_id ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: efn */
	if (ar_efn == Py_None)
	{
	    l_efn = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_efn))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: efn - must be integer or None");
		return NULL;
	    }
	    l_efn = PyInt_AsLong(ar_efn);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 2: lkmode - not optional */

	/* -------------------- */
	/* argument 3: lksb */
	l_lksb_alloc = 0;
	if (ar_py_lksb == (vmsobj_lksb *)Py_None)
	{
	    l_lksb_alloc = 1;
	    /* create a new vmsobj_lksb object */
	    ar_py_lksb = vmsobj_lksb_new (NULL);
	    if (ar_py_lksb == NULL)
	    {
		return NULL;
	    }
	}
	else
	{
	    if (!vmsobj_lksb_Check(ar_py_lksb))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: lksb - must be vmsobj_lksb or None");
		return NULL;
	    }
	}
	ar_vms_lksb = ar_py_lksb->ab_lksb;

	/* -------------------- */
	/* argument 4: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 5: resnam */
	if (at_resnam == NULL)
	{
	    ar_resnam = 0;	/* omitted */
	}
	else
	{
	    if (l_resnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		"argument 5: resnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_resnam.dsc$w_length  = l_resnam_len;
	    r_resnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_resnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_resnam.dsc$a_pointer = at_resnam;
	    ar_resnam = &r_resnam;
	}

	/* -------------------- */
	/* argument 6: parid */
	if (ar_parid == Py_None)
	{
	    l_parid = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_parid))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: parid - must be integer or None");
		return NULL;
	    }
	    l_parid = PyInt_AsLong(ar_parid);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 7: astadr */		/* @@ ignored */
	/* -------------------- */
	/* argument 8: astprm */		/* @@ ignored */
	/* -------------------- */
	/* argument 9: blkast */		/* @@ ignored */

	/* -------------------- */
	/* argument 10: acmode */
	if (ar_acmode == Py_None)
	{
	    l_acmode = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 10: acmode - must be integer or None");
		return NULL;
	    }
	    l_acmode = PyInt_AsLong(ar_acmode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 11: rdsm_id */
	if (ar_rdsm_id == Py_None)
	{
	    l_rdsm_id = 0;		/* omitted - use default */
	}
	else
	{
	    if (!PyInt_Check(ar_rdsm_id))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 11: rdsm_id - must be integer or None");
		return NULL;
	    }
	    l_rdsm_id = PyInt_AsLong(ar_rdsm_id);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$enqw
			(l_efn		/* BY VALUE */
			,l_lkmode	/* BY VALUE */
			,ar_vms_lksb
			,l_flags	/* BY VALUE */
			,ar_resnam
			,l_parid	/* BY VALUE */
			,0		/* [astadr] - @@ ignored */
			,0		/* [astprm] - @@ ignored */
			,0		/* [blkast] - @@ ignored */
			,l_acmode	/* BY VALUE */
			,l_rdsm_id	/* BY VALUE */
			);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    if (l_lksb_alloc)
	    {
		Py_DECREF(ar_py_lksb);
	    }
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    if (l_lksb_alloc)
	    {
		Py_DECREF(ar_py_lksb);
	    }
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    if (l_lksb_alloc)
	    {
		Py_DECREF(ar_py_lksb);
	    }
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* return 'lksb' */
	ar_dictobj = (PyObject *)ar_py_lksb;
	Py_INCREF (ar_dictobj);
	if (PyDict_SetItemString(ar_dict, "lksb", ar_dictobj) < 0)
	{
	    if (l_lksb_alloc)
	    {
		Py_DECREF(ar_py_lksb);
	    }
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

	
} /* vms_sys_enqw () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_ENQW.C */
