/* VMS_SYS_FILESCAN.C -- 17-OCT-1998 Uwe Zessin
   Python interface to SYS$FILESCAN()

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------ */
/* Note: input to the item-list is called 'item code',		*/
/*	 but the data returned is called '(filename) component'.*/
/* A lot of code is copied, and the vocabulary might not	*/
/*   have been adjusted everywhere.				*/
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */

#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;
/* ------------------------------------------------------------------------- */
/* reference to translation table for FSCN$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$FSCNDEF[];
/* ------------------------------------------------------------------------- */

char vms_sys_filescan__doc[] =
"dict = vms_sys.filescan (srcstr, valuelst)\n\
Scan String for File Specification.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_filescan (PyObject *self, PyObject *args)
{
	char			* at_srcstr;
	struct dsc$descriptor_s   r_srcstr;
	struct dsc$descriptor_s * ar_srcstr;
	unsigned long		  l_srcstr_len;

	/* ----- */
	/* item-list - tuple of tuples:                    */
	/*  ( ('FSCN$_name',data), ('FSCN$_name',data), ...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to SYS$FILESCAN() */
	struct vmsdef_xr_itmlst2 * ar_itemlist;		/* start address */
	struct vmsdef_xr_itmlst2 * ar_itemlist_ptr;	/* walk along    */

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl * * ar_itm_vmsdef;	/* start address */
	struct vmsdef_xr_itmtbl * * ar_itm_vmsdef_ptr;	/* walk along    */

	unsigned long		  l_itmlst_size;	/* number of strings */
	unsigned long		  l_itmlst_idx;		/* index into "      */

	/* item string - ('FSCN$_name',) */
	PyObject		* ar_py_item_tuple;	/* item tuple */

	PyObject		* ar_py_item_code;	/* FSCN$_name  */
	char			* at_item_code;		/* "	       */
	unsigned short int	  w_item_code;		/* from VMSDEF */

	unsigned long		  l_trn_idx; /* into VMSDEF_GR_$FSCNDEF[] */

	unsigned long		  l_malloc_bytes;	/* for malloc() */
	/* ----- */

	unsigned long		  l_fldflags;

#define S_AUXOUT 65535
	char			* at_auxout;
	struct dsc$descriptor_s   r_auxout;

	unsigned short int	  w_retlen;

	unsigned long		  l_status;

	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#O",
	    &at_srcstr, &l_srcstr_len, &ar_py_item_list))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: srcstr */
	if (l_srcstr_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: srcstr - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_srcstr.dsc$w_length  = l_srcstr_len;
	r_srcstr.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_srcstr.dsc$b_class   = DSC$K_CLASS_S;
	r_srcstr.dsc$a_pointer = at_srcstr;

	/* -------------------- */
	/* argument 2: valuelst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 2: valuelst - must be a tuple of strings");
	    return NULL;
	}

	l_itmlst_size = PyTuple_Size(ar_py_item_list);

	/* -------------------- */
	/* allocate memory for:
	||	- each item-list element
	||	- the item-list termination element
	*/
	l_malloc_bytes =
	    ( (l_itmlst_size * sizeof(struct vmsdef_xr_itmlst2)) + /* items */
	      sizeof(struct vmsdef_xr_itmlst2)	 /* termination of itemlist */
	    );
	ar_itemlist = malloc (l_malloc_bytes);
	if (ar_itemlist == NULL)
	{
	    return PyErr_NoMemory();
	}
	/* Set the allocated memory to 0. */
	(void) memset (ar_itemlist, 0, l_malloc_bytes);

	/* ar_itemlist_ptr is used to walk along the individual elements */
	/*  in the VMS item-list */
	ar_itemlist_ptr = ar_itemlist;

	/* ---------------------------------------- */
	/* allocate memory for:
	||	- an array of pointers from the item to its corresponding
	||	  VMSDEF structure element
	*/
	l_malloc_bytes = (l_itmlst_size * 4);	/* for VMSDEF pointers % */
						/* % - needs no termination */
	ar_itm_vmsdef = malloc (l_malloc_bytes);
	if (ar_itm_vmsdef == NULL)
	{
	    (void) free (ar_itemlist);		/* prevent memory leak */
	    return PyErr_NoMemory();
	}
	ar_itm_vmsdef_ptr = ar_itm_vmsdef;	/* used to walk over array */

/* -------------------- -------------------- */
/* loop over item-list */
for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; l_itmlst_idx++)
{
  /* get item-list element - ('FSCN$_name',...) */
  ar_py_item_code = PyTuple_GetItem(ar_py_item_list, l_itmlst_idx);
  if (ar_py_item_code == NULL)
  {
    (void) free (ar_itemlist);		/* free item-list */
    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
    return NULL;
  }
  /* -------------------- */
  /* each list element must be a string ('FSCN$_name') */
  if (!PyString_Check(ar_py_item_code))
  {
    (void) free (ar_itemlist);		/* free item-list */
    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
    return PyErr_Format(PyExc_TypeError,
	"argument 2: valuelst - item:%d is not a string", l_itmlst_idx);
  }
  /* -------------------- */
  /* convert item-code string to FSCN$_ numerical value */
  l_trn_idx    = 0;
  at_item_code = PyString_AS_STRING(ar_py_item_code);
  while (VMSDEF_GR_$FSCNDEF[l_trn_idx].w_vmsvermin != 0)
  {
    /* check VMS version */
    if ((VMSDEF_GR_$FSCNDEF[l_trn_idx].w_vmsvermin <= vmsdef_gw_vmsver) &&
	(VMSDEF_GR_$FSCNDEF[l_trn_idx].w_vmsvermax >= vmsdef_gw_vmsver)  )
    {
      /* compare item name */
      if (strcmp(at_item_code,VMSDEF_GR_$FSCNDEF[l_trn_idx].at_itmnam_py) == 0)
      {
	/* @@ this must be an OUTPUT item-code */
	/*  $FILESCAN does not take any INPUT item-codes */
			/* ... */
	/* found textual match - use numerical value of item-code */
	w_item_code = VMSDEF_GR_$FSCNDEF[l_trn_idx].w_itmcod;
	break;				/* leave while() loop */
      } /* item code string match */
    } /* w_vmsvermin / w_vmsvermax match with vmsdef_gw_vmsver */
    l_trn_idx++;				/* check next item code */
  } /* while (VMSDEF_GR_$FSCNDEF[l_trn_idx].w_vmsvermin != 0) */

  /* -------------------- */
  if (VMSDEF_GR_$FSCNDEF[l_trn_idx].w_vmsvermin == 0)
  {
    /* item code not found - abort */
    (void) free (ar_itemlist);		/* free item-list */
    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
    return PyErr_Format(PyExc_ValueError,
	"argument 2: valuelst - unknown item code: %.100s", at_item_code);
  }

  /* -------------------- */
  /* printf ("@@itm:%s=%d\n", PyString_AS_STRING(ar_py_item_code), (int)w_item_code); */

  /* -------------------- */
  /* only process output-items, ignore input-items */
  if (VMSDEF_GR_$FSCNDEF[l_trn_idx].l_flags & ITMTBL_M_ITMOUT)
  {
    /* store numerical item-code into VMS item-list */
    ar_itemlist_ptr->w_itmcod = w_item_code;

    /* -------------------- */
    /* store pointer to VMSDEF entry for this item-code    */
    /* because this is used in a decision to build the dictionary */
    /* which is returned to Python */
    *ar_itm_vmsdef_ptr = &VMSDEF_GR_$FSCNDEF[l_trn_idx];

    /* -------------------- */
    ar_itemlist_ptr++;		/* next address of itemlist element  */
    ar_itm_vmsdef_ptr++;	/* next pointer into VMSDEF	     */
  }
  else
  {
    /* skip any input item codes */
  }
  /* -------------------- */
} /* for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; .. */
/* -------------------- -------------------- */
	/* terminate VMS item-list */
	ar_itemlist_ptr->w_itmcod = 0;
	ar_itemlist_ptr->w_bufsiz = 0;

	/* -------------------- */
	/* allocate 64K auxout string */
	at_auxout = malloc (S_AUXOUT);
	if (at_auxout == NULL)
	{
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    return PyErr_NoMemory();
	}

	/* -------------------- */
	/* build string descriptor */
	r_auxout.dsc$w_length  = S_AUXOUT;
	r_auxout.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_auxout.dsc$b_class   = DSC$K_CLASS_S;
	r_auxout.dsc$a_pointer = at_auxout;

	/* -------------------- */
	l_status = sys$filescan
		(&r_srcstr
		,ar_itemlist
		,&l_fldflags
		,&r_auxout
		,&w_retlen
		);

	/* -------------------- */
	/* update string descriptor to ease debugging DBG> EXA/ASCID */
	r_auxout.dsc$w_length = w_retlen;

	/* -------------------- */
	/* create a dictionary to return a varying number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    (void) free (at_auxout);
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    (void) free (at_auxout);
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    Py_DECREF(ar_dict);			/* drop dictionary */
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    (void) free (at_auxout);
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    Py_DECREF(ar_dict);			/* drop dictionary */
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);
	/* -------------------- */

    if (l_status == SS$_NORMAL)
    {
	/* -------------------- */
	/* return fldflags */
	ar_dictobj = PyInt_FromLong(l_fldflags);
	if (ar_dictobj == NULL)
	{
	    (void) free (at_auxout);
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    Py_DECREF(ar_dict);			/* drop dictionary */
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "fldflags", ar_dictobj) < 0)
	{
	    (void) free (at_auxout);
	    (void) free (ar_itemlist);		/* free item-list */
	    (void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
	    Py_DECREF(ar_dict);			/* drop dictionary */
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);
	/* -------------------- */
	/* loop over item-list and VMSDEF back-pointer array */
	/*  to process the output items */
	ar_itemlist_ptr   = ar_itemlist;
	ar_itm_vmsdef_ptr = ar_itm_vmsdef;

	/* -------------------- */
	for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; l_itmlst_idx++)
	{
	  if (ar_itemlist_ptr->w_bufsiz != 0)
	  {
	    /* SYS$FILESCAN did locate this component */
	    /* ----- */
	    /* build component data */
	    ar_dictobj = Py_BuildValue ("s#",
		    ar_itemlist_ptr->a_bufadr,			/* data */
		    (unsigned int)ar_itemlist_ptr->w_bufsiz);	/* size */
	    if (ar_dictobj == NULL)
	    {
		(void) free (at_auxout);
		(void) free (ar_itemlist);	/* free item-list */
		(void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
		Py_DECREF(ar_dict);		/* drop dictionary */
		return NULL;
	    }
	
	    /* store item-name ('FSCN$_name') + data into dictionary */
	    if (PyDict_SetItemString(ar_dict
					,(*ar_itm_vmsdef_ptr)->at_itmnam_py
					,ar_dictobj)
				     < 0)
	    {
		(void) free (at_auxout);
		(void) free (ar_itemlist);	/* free item-list */
		(void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */
		Py_DECREF(ar_dict);		/* drop dictionary */
		Py_DECREF(ar_dictobj);
		return NULL;
	    }
	    Py_DECREF(ar_dictobj);
	  } /* if (ar_itemlist_ptr->w_bufsiz != 0) */
	
	  /* ---------------------------------------- */
	  /* next item/component */
	  ar_itemlist_ptr++;		/* next address of itemlist element  */
	  ar_itm_vmsdef_ptr++;		/* next pointer into VMSDEF	     */
	
	} /* for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; .. */
	/* -------------------- */
    }
	(void) free (at_auxout);
	(void) free (ar_itemlist);	/* free item-list */
	(void) free (ar_itm_vmsdef);	/* free VMSDEF back-pointers */

	return ar_dict;

} /* vms_sys_filescan () */

/* ------------------------------------------------------------------------- */

/* ----------

# memory-leak test 1:
import vms_sys
import vms_fscndef

srcstr   = 'NODNAM::DEV_STR:[UFD.SD]NAM.TYP;VER'
valuelst = ('FSCN$_NODE', 'FSCN$_NAME', 'FSCN$_TYPE')
while (1):
    dict = vms_sys.filescan (srcstr, valuelst)
# -while

---------- */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_FILESCAN.C */
