/* VMS_SYS_FLUSH.C -- 26-FEB-1999 Uwe Zessin
   Python interface to SYS$FLUSH()
*/


#include "python.h"

#include <starlet.h>		/* SYS$name, ... */

#include "vmsobj_rab.h"

/* ------------------------------------------------------------------------- */

char vms_sys_flush__doc[] =
"status = vms_sys.flush (rab, [err], [suc])\n\
Flush modified I/O Buffers amd File attributes to Disk (RMS).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_flush (PyObject *self, PyObject *args)
{
	vmsobj_rab		* ar_py_rab;
	struct RAB		* ar_vms_rab;

	PyObject		* ar_py_err;
	long			* al_err;

	PyObject		* ar_py_suc;
	long			* al_suc;

	unsigned long		  l_status;

	/* -------------------- */
	ar_py_err = Py_None;
	ar_py_suc = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O|OO",
	    &ar_py_rab,
	    &ar_py_err,
	    &ar_py_suc ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: rab */
	if (! vmsobj_rab_Check(ar_py_rab))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: rab - must be vmsobj_rab object");
	    return NULL;
	}
	ar_vms_rab = ar_py_rab->ab_rab;

	/* -------------------- */
	/* argument 2: err - ignored */
	al_err = 0;

	/* -------------------- */
	/* argument 3: suc - ignored */
	al_suc = 0;

	/* -------------------- */
	l_status = sys$flush
		(ar_vms_rab	/* rab   */
		,al_err		/* [err] */
		,al_suc		/* [suc] */
		);

	/* -------------------- */
	return PyInt_FromLong(l_status);
} /* vms_sys_flush () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_FLUSH.C */
