/* VMS_SYS_FORMAT_ACL.C -- 27-JUN-1999 Uwe Zessin
   Python interface to SYS$FORMAT_ACL()
*/

#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_format_acl__doc[] =
"status, aclstr = vms_sys.format_acl (\
aclent ,[width] ,[trmdsc] ,[indent] ,[accnam] ,[nullarg])\n\
Formats the specified access control entry (ACE) into a text string.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_format_acl (PyObject *self, PyObject *args)
{
	PyObject		* ar_aclent;
	char			* at_aclent;
	struct dsc$descriptor_s   r_aclent;
	unsigned long		  l_aclent_len;

	PyObject		* ar_width;
	unsigned long		  l_width;
	unsigned short int	  w_width;
	unsigned short int	* aw_width;

	char			* at_trmdsc;
	struct dsc$descriptor_s   r_trmdsc;
	struct dsc$descriptor_s * ar_trmdsc;
	unsigned long		  l_trmdsc_len;

	PyObject		* ar_indent;
	unsigned long		  l_indent;
	unsigned short int	  w_indent;
	unsigned short int	* aw_indent;

	PyObject		* ar_accnam;
	long			* aq_access_names;

	PyObject		* ar_nullarg;

	char			* at_aclstr;
	struct dsc$descriptor_s   r_aclstr;
	unsigned short int	  w_acllen;
	PyObject		* ar_return;	/* output */

	unsigned long		  l_status;

	/* -------------------- */
	ar_width   = Py_None;
	at_trmdsc  = NULL;    l_trmdsc_len = 0;
	ar_indent  = Py_None;
	ar_accnam  = Py_None;
	ar_nullarg = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O|Oz#OOO",
	    &ar_aclent,
	    &ar_width,
	    &at_trmdsc, &l_trmdsc_len,
	    &ar_indent,
	    &ar_accnam,
	    &ar_nullarg ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: aclent */
	/* @@ could also be vmsobj_membuf object */
	if (! PyString_Check(ar_aclent))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: aclent - must be string");
	    return NULL;
	}

	at_aclent    = PyString_AS_STRING(ar_aclent);
	l_aclent_len = PyString_Size(ar_aclent);

	if (l_aclent_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: aclent - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up descriptor */
	r_aclent.dsc$w_length  = l_aclent_len;
	r_aclent.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_aclent.dsc$b_class   = DSC$K_CLASS_S;
	r_aclent.dsc$a_pointer = at_aclent;

	/* -------------------- */
	/* argument 2: width */
	if (ar_width == Py_None)
	{
	    aw_width = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_width))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: width - must be integer or None");
		return NULL;
	    }
	    l_width = PyInt_AsLong(ar_width);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    w_width  = l_width;
	    aw_width = &w_width;
	}

	/* -------------------- */
	/* argument 3: trmdsc */
	if (at_trmdsc == NULL)
	{
	    ar_trmdsc = 0;		/* omitted */
	}
	else
	{
	    if (l_trmdsc_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 3: trmdsc - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_trmdsc.dsc$w_length  = l_trmdsc_len;
	    r_trmdsc.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_trmdsc.dsc$b_class   = DSC$K_CLASS_S;
	    r_trmdsc.dsc$a_pointer = at_trmdsc;
	    ar_trmdsc = &r_trmdsc;
	}

	/* -------------------- */
	/* argument 4: indent */
	if (ar_indent == Py_None)
	{
	    aw_indent = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_indent))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: indent - must be integer or None");
		return NULL;
	    }
	    l_indent = PyInt_AsLong(ar_indent);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    w_indent  = l_indent;
	    aw_indent = &w_indent;
	}

	/* -------------------- */
	/* argument 5: accnam */
	if (ar_accnam == Py_None)
	{
	    aq_access_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__access_names_Check(ar_accnam))
	    {
		PyErr_SetString(PyExc_TypeError,
		  "argument 5: accnam - must be vmsobj__access_names or None");
		return NULL;
	    }
	    aq_access_names =
			((vmsobj__access_names *) ar_accnam)->aq_access_names;
	}

	/* -------------------- */
	/* argument 6: nullarg */
	if (ar_nullarg != Py_None)
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 6: nullarg - must be None or omitted");
	    return NULL;
	}

	/* -------------------- */
	/* allocate memory for 'aclstr' */
#define S_ACLSTR 65535
	at_aclstr = malloc (S_ACLSTR);
	if (at_aclstr == NULL)
	{
	    PyErr_NoMemory();
	    return NULL;
	}
	/* set up descriptor */
	r_aclstr.dsc$w_length  = S_ACLSTR;
	r_aclstr.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_aclstr.dsc$b_class   = DSC$K_CLASS_S;
	r_aclstr.dsc$a_pointer = at_aclstr;

	/* -------------------- */
	l_status = sys$format_acl
			(&r_aclent
			,&w_acllen
			,&r_aclstr
			,aw_width
			,ar_trmdsc
			,aw_indent
			,aq_access_names
			,0		/* [nullarg] */
			);

	/* -------------------- */
	/* help debugging: DBG> examine/ascid */
	r_aclstr.dsc$w_length = w_acllen;

	/* -------------------- */
	/* return ACL string */
	if ( (l_status == SS$_NORMAL) || (l_status == SS$_BUFFEROVF) )
	{
	    ar_return = Py_BuildValue ("ls#", l_status,
				at_aclstr, (unsigned int)w_acllen);
	}

	(void) free (at_aclstr);

	if ( (l_status == SS$_NORMAL) || (l_status == SS$_BUFFEROVF) )
	{
	    return ar_return;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_format_acl () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_FORMAT_ACL.C */
