/* VMS_SYS_GETJPIW.C -- 05-FEB-1999 Uwe Zessin
   Python interface to SYS$GETJPIW()

Note: the [astadr] and [astprm] arguments are not implemented.
*/


#include "python.h"
#include "vmsdef.h"
#include "vmsobj_iosb.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for JPI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$JPIDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_getjpiw__doc[] =
"dict = vms_sys.getjpiw ([efn] [,pidadr] [,prcnam], itmlst [,iosb]\
 [,astadr] [,astprm])\n\
Get Job/Process Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_getjpiw (PyObject *self, PyObject *args)
{
	PyObject		* ar_efn;
	unsigned long		  l_efn;

	unsigned long		  l_pidadr;
	unsigned long		* al_pidadr;
	PyObject		* ar_pidadr;

	char			* at_prcnam;
	struct dsc$descriptor_s   r_prcnam;
	struct dsc$descriptor_s	* ar_prcnam;
	unsigned long		  l_prcnam_len;

	/* item-list - tuple of strings = ('JPI$_name','JPI$_name',...) */
	PyObject		* ar_py_item_list;

	PyObject		* ar_arg5;
	PyObject		* ar_arg6;
	PyObject		* ar_arg7;
	PyObject		* ar_arg8;

	/* VMS item-list to be passed to SYS$GETJPIW() */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	vmsobj_iosb		* ar_py_iosb;
	long			* aq_vms_iosb;

	PyObject		* ar_astadr;	/* @@ ignored */
	PyObject		* ar_astprm;	/* @@ ignored */

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	ar_efn     = Py_None;
	ar_pidadr  = Py_None;
	at_prcnam  = NULL;
	ar_py_iosb = (vmsobj_iosb *)Py_None;
	ar_astadr  = Py_None;	/* @@ ignored */
	ar_astprm  = Py_None;	/* @@ ignored */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OOz#O|OOO",
	    &ar_efn,
	    &ar_pidadr,
	    &at_prcnam, &l_prcnam_len,
	    &ar_py_item_list,
	    &ar_py_iosb,
	    &ar_astadr,
	    &ar_astprm ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: efn */
	if (ar_efn == Py_None)
	{
	    l_efn = 0;			/* omitted - BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_efn))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: efn - must be integer or None");
		return NULL;
	    }
	    l_efn = PyInt_AsLong(ar_efn);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 2: pidadr */
	if (ar_pidadr == Py_None)
	{
	    /* turn 'None' into '0' because argument 3 might be present */
	    /*   and this routine has to return a PID */
	    l_pidadr = 0;
	}
	else
	{
	    if (!PyInt_Check(ar_pidadr))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: pidadr - must be integer or None");
		return NULL;
	    }
	    l_pidadr = PyInt_AsLong(ar_pidadr);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}
	al_pidadr = &l_pidadr;

	/* -------------------- */
	/* argument 3: prcnam */
	if (at_prcnam == NULL)
	{
	    ar_prcnam = 0;		/* omitted */
	}
	else
	{
	    if (l_prcnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 3: prcnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_prcnam.dsc$w_length  = l_prcnam_len;
	    r_prcnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_prcnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_prcnam.dsc$a_pointer = at_prcnam;
	    ar_prcnam = &r_prcnam;
	}

	/* -------------------- */
	/* argument 4: itmlst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 4: itmlst - must be a tuple of tuples/strings");
	    return NULL;
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$JPIDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	/* argument 5: iosb */
	if (ar_py_iosb == (vmsobj_iosb *)Py_None)
	{
	    /* create a new vmsobj_iosb object */
	    ar_py_iosb = vmsobj_iosb_new (NULL);
	    if (ar_py_iosb == NULL)
	    {
	      /* free item-list *and* all malloc()ed buffers */
	      (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	      return NULL;
	    }
	}
	else
	{
	    if (!vmsobj_iosb_Check(ar_py_iosb))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: iosb - must be vmsobj_iosb or None");
		return NULL;
	    }
	}
	aq_vms_iosb = ar_py_iosb->aq_iosb;

	/* -------------------- */
	/* argument 6: astadr - @@ ignored */

	/* -------------------- */
	/* argument 7: astprm - @@ ignored */

	/* -------------------- */
	l_status = sys$getjpiw
		(l_efn		/* [efn] - BY VALUE */
		,al_pidadr 	/* [pidadr]	    */
		,ar_prcnam	/* [prcnam]	    */
		,ar_itemlist	/* itmlst	    */
		,aq_vms_iosb	/* [iosb]	    */
		,0		/* [astadr] @@ ignored */
		,0		/* [astprm] @@ ignored */
		);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* return 'pidadr' */
	ar_dictobj = PyInt_FromLong(l_pidadr);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "pidadr", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}

	/* -------------------- */
	/* return 'iosb' */
	ar_dictobj = (PyObject *)ar_py_iosb;
	Py_INCREF (ar_dictobj);
	if (PyDict_SetItemString(ar_dict, "iosb", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}

	/* -------------------- */
	/* build remaining items only if system service returned 'success' */
	if (l_status == SS$_NORMAL)
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$JPIDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	/* no check necessary - item-list must always be present */
	/* -------------------- */
	/* free item-list *and* all malloc()ed buffers */
	(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);

	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_getjpiw () */

/* ------------------------------------------------------------------------- */

/* ----------

# memory-leak test 1:
$python
import vms_sys
while (1):
    dict = vms_sys.getjpiw (None,None,'SYSTEM',
    ('JPI$_ACCOUNT'          ,'JPI$_ASTLM'
    ,'JPI$_BATCH_ACCESS_P'   ,'JPI$_BATCH_ACCESS_S'
    ,'JPI$_BIOLM'            ,'JPI$_BYTLM'
    ,'JPI$_CLITABLES'        ,'JPI$_CPUTIM'
    ,'JPI$_DEFCLI'           ,'JPI$_DEFDEV'
    ,'JPI$_DEFDIR'           ,'JPI$_DEF_PRIV'
    ,'JPI$_DFWSCNT'          ,'JPI$_DIALUP_ACCESS_P'
    ,'JPI$_DIALUP_ACCESS_S'  ,'JPI$_DIOLM'
    ,'JPI$_ENCRYPT'          ,'JPI$_ENCRYPT2'
    ,'JPI$_ENQLM'            ,'JPI$_EXPIRATION'
    ,'JPI$_FILLM'            ,'JPI$_FLAGS'
    ,'JPI$_GRP'              ,'JPI$_JTQUOTA'
    ,'JPI$_LASTLOGIN_I'      ,'JPI$_LASTLOGIN_N'
    ,'JPI$_LGICMD'           ,'JPI$_LOCAL_ACCESS_P'
    ,'JPI$_LOCAL_ACCESS_S'   ,'JPI$_LOGFAILS'
    ,'JPI$_MAXACCTJOBS'      ,'JPI$_MAXDETACH'
    ,'JPI$_MAXJOBS'          ,'JPI$_MEM'
    ,'JPI$_NETWORK_ACCESS_P' ,'JPI$_NETWORK_ACCESS_S'
    ,'JPI$_OWNER'            ,'JPI$_PBYTLM'
    ,'JPI$_PGFLQUOTA'        ,'JPI$_PRCCNT'
    ,'JPI$_PRI'              ,'JPI$_PRIMEDAYS'
    ,'JPI$_PRIV'             ,'JPI$_PWD'
    ,'JPI$_PWD2'             ,'JPI$_PWD2_DATE'
    ,'JPI$_PWD_DATE'         ,'JPI$_PWD_LENGTH'
    ,'JPI$_PWD_LIFETIME'     ,'JPI$_QUEPRI'
    ,'JPI$_REMOTE_ACCESS_P'  ,'JPI$_REMOTE_ACCESS_S'
    ,'JPI$_SALT'             ,'JPI$_SHRFILLM'
    ,'JPI$_TQCNT'            ,'JPI$_UIC'
    ,'JPI$_USERNAME'         ,'JPI$_USER_DATA'
    ,'JPI$_WSEXTENT'         ,'JPI$_WSQUOTA'
    ))
# -while

---------- */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_GETJPIW.C */
