/* VMS_SYS_GETMSG.C -- 17-OCT-1998 Uwe Zessin
   Python interface to SYS$GETMSG()
*/

/* ------------------------------------------------------------ */

#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_getmsg__doc[] =
"bufadr, outadr = vms_sys.getmsg (msgid [,flags])\n\
Get Message.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_getmsg (PyObject *self, PyObject *args)
{
	unsigned long		  l_msgid;

	unsigned short int	  w_msglen;

#define S_BUFADR 256
	char			  t_bufadr[S_BUFADR];
	struct dsc$descriptor_s   r_bufadr;

	PyObject		* ar_flags;
	unsigned long		  l_flags;

	unsigned long		  l_outadr; /* 4*B */

	unsigned long		  l_status;

	/* -------------------- */
	ar_flags = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l|O",
	    &l_msgid, &ar_flags))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: msgid */

	/* -------------------- */
	/* argument 2: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* build string descriptor */
	r_bufadr.dsc$w_length  = S_BUFADR;
	r_bufadr.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_bufadr.dsc$b_class   = DSC$K_CLASS_S;
	r_bufadr.dsc$a_pointer = &t_bufadr[0];

	/* -------------------- */
	l_status = sys$getmsg
		(l_msgid	/* by value */
		,&w_msglen
		,&r_bufadr
		,l_flags	/* by value */
		,&l_outadr
		);

	/* -------------------- */
	/* update string descriptor to ease debugging DBG> EXA/ASCID */
	r_bufadr.dsc$w_length = w_msglen;

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    PyObject	* ar_bufadr;
	    PyObject	* ar_tuple;	/* Python tuple returning all */
					/* data elements of a single item */
	    PyObject	* ar_intobj;	/* Python data element to be */
					/* inserted in tuple */

	    unsigned long    loop;
	    unsigned long    l_data;
	    unsigned char  * at_data;

	    PyObject	* ar_return;

	    /* outadr is a tuple of 4 bytes */
	    ar_tuple = PyTuple_New(4);
	    if (ar_tuple == NULL)
	    {
		return NULL;
	    }
	    at_data = (unsigned char *)&l_outadr;
	    /* loop over all elements in the tuple */
	    for (loop = 0; loop < 4; loop++)
	    {			/*^-- 4 Byte in a Longword */
		l_data = 0;
		l_data = (*at_data) & 0xff;
		(char *)at_data++;		/* ptr to next element */

		ar_intobj = PyInt_FromLong(l_data);
		if (ar_intobj == NULL)
		{
		    Py_DECREF(ar_tuple);	/* drop tuple */
		    return NULL;
		}

		if (PyTuple_SetItem(ar_tuple, loop, ar_intobj) != 0)
		{
		    Py_DECREF(ar_intobj);
		    Py_DECREF(ar_tuple);
		    return NULL;
		}
	    } /* for() loop over all tuple elements */

	    ar_bufadr = Py_BuildValue ("s#",
					&t_bufadr[0], (unsigned int)w_msglen);
	    if (ar_bufadr == NULL)
	    {
		Py_DECREF(ar_tuple);
		return NULL;
	    }

	    ar_return = Py_BuildValue ("OO", ar_bufadr, ar_tuple);
	    Py_DECREF(ar_bufadr);
	    Py_DECREF(ar_tuple);

	    return ar_return;
	} /* (l_status == SS$_NORMAL) */

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_getmsg () */

/* ------------------------------------------------------------------------- */
/*
--  memory leak tests  --

-----

# -- check 1
import vms_sys
while (1):
  bufadr, outadr = vms_sys.getmsg (0x2c)
# -while

-----

# -- check 2
import vms_sys
while (1):
  try:
    bufadr, outadr = vms_sys.getmsg ('ERR')
  except (TypeError):
    pass
# -while

*/

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_GETMSG.C */
