/* VMS_SYS_GETUAI.C -- 06-SEP-1998 Uwe Zessin
   Python interface to SYS$GETUAI()

   29-DEC-1998 ZE. -- modify to use common item-list routines
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for UAI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$UAIDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_getuai__doc[] =
"dict = vms_sys.getuai (None, None, usrnam, itmlst [,None] [,None] [,None])\n\
Get User Authorization Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_getuai (PyObject *self, PyObject *args)
{
	PyObject		* ar_arg1;

	PyObject		* ar_contxt;
	unsigned long		  l_contxt;
	unsigned long		* al_contxt;

	char			* at_usrnam;
	struct dsc$descriptor_s   r_usrnam;
	unsigned long		  l_usrnam_len;

	/* item-list - tuple of strings = ('UAI$_name','UAI$_name',...) */
	PyObject		* ar_py_item_list;

	PyObject		* ar_arg5;
	PyObject		* ar_arg6;
	PyObject		* ar_arg7;
	PyObject		* ar_arg8;

	/* VMS item-list to be passed to SYS$GETUAI() */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	unsigned long		    l_status;
	PyObject		  * ar_dict;	/* dictionary to be returned */
	PyObject		  * ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OOs#O|OOO",
	    &ar_arg1, &ar_contxt, &at_usrnam, &l_usrnam_len,
	    &ar_py_item_list, &ar_arg6, &ar_arg7, &ar_arg8))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: nullarg - ignore */
	/* argument 6 - 8: nullarg - ignore */

	/* -------------------- */
	/* argument 2: contxt - can be 'None' or int */
	if (ar_contxt == Py_None)
	{
	    al_contxt = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_contxt))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: contxt - must be integer or None");
		return NULL;
	    }
	    l_contxt = PyInt_AsLong(ar_contxt);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_contxt = &l_contxt;
	}

	/* -------------------- */
	/* argument 3: usrnam */
	if (l_usrnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 3: usrnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_usrnam.dsc$w_length  = l_usrnam_len;
	r_usrnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_usrnam.dsc$b_class   = DSC$K_CLASS_S;
	r_usrnam.dsc$a_pointer = at_usrnam;

	/* -------------------- */
	/* argument 4: itmlst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 4: itmlst - must be a tuple of strings");
	    return NULL;
	}
	else
	{
	    PyObject * ar_xxx;

	    /* SYS$GETUAI currently (V6.1) does not have any input-items */
	    ar_xxx = vms__itmlst_build
		(0 /* ITMTBL_M_ITMINP */	/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$UAIDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	l_status = sys$getuai
		(0		/* [nullarg] */
		,al_contxt 	/* [contxt]  */
		,&r_usrnam	/* usrnam    */
		,ar_itemlist	/* itmlst    */
		,0		/* [nullarg] */
		,0		/* [nullarg] */
		,0		/* [nullarg] */
		);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* return 'contxt' if it was supplied as argument 2 */
	if (al_contxt != 0)
	{
	    ar_dictobj = PyInt_FromLong(l_contxt);
	    if (ar_dictobj == NULL)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		return NULL;
	    }
	    if (PyDict_SetItemString(ar_dict, "contxt", ar_dictobj) < 0)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		Py_DECREF(ar_dictobj);
		return NULL;
	    }
	    Py_DECREF(ar_dictobj);
	}

	/* -------------------- */
	/* build remaining items only if system service returned 'success' */
	if (l_status == SS$_NORMAL)
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$UAIDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	/* no check necessary - item-list must always be present */
	/* -------------------- */
	/* free item-list *and* all malloc()ed buffers */
	(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);

	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_getuai () */

/* ------------------------------------------------------------------------- */

/* ----------

# memory-leak test 1:
$python
import vms_sys
while (1):
    dict = vms_sys.getuai (None,None,'SYSTEM',
    ('UAI$_ACCOUNT'          ,'UAI$_ASTLM'
    ,'UAI$_BATCH_ACCESS_P'   ,'UAI$_BATCH_ACCESS_S'
    ,'UAI$_BIOLM'            ,'UAI$_BYTLM'
    ,'UAI$_CLITABLES'        ,'UAI$_CPUTIM'
    ,'UAI$_DEFCLI'           ,'UAI$_DEFDEV'
    ,'UAI$_DEFDIR'           ,'UAI$_DEF_PRIV'
    ,'UAI$_DFWSCNT'          ,'UAI$_DIALUP_ACCESS_P'
    ,'UAI$_DIALUP_ACCESS_S'  ,'UAI$_DIOLM'
    ,'UAI$_ENCRYPT'          ,'UAI$_ENCRYPT2'
    ,'UAI$_ENQLM'            ,'UAI$_EXPIRATION'
    ,'UAI$_FILLM'            ,'UAI$_FLAGS'
    ,'UAI$_GRP'              ,'UAI$_JTQUOTA'
    ,'UAI$_LASTLOGIN_I'      ,'UAI$_LASTLOGIN_N'
    ,'UAI$_LGICMD'           ,'UAI$_LOCAL_ACCESS_P'
    ,'UAI$_LOCAL_ACCESS_S'   ,'UAI$_LOGFAILS'
    ,'UAI$_MAXACCTJOBS'      ,'UAI$_MAXDETACH'
    ,'UAI$_MAXJOBS'          ,'UAI$_MEM'
    ,'UAI$_NETWORK_ACCESS_P' ,'UAI$_NETWORK_ACCESS_S'
    ,'UAI$_OWNER'            ,'UAI$_PBYTLM'
    ,'UAI$_PGFLQUOTA'        ,'UAI$_PRCCNT'
    ,'UAI$_PRI'              ,'UAI$_PRIMEDAYS'
    ,'UAI$_PRIV'             ,'UAI$_PWD'
    ,'UAI$_PWD2'             ,'UAI$_PWD2_DATE'
    ,'UAI$_PWD_DATE'         ,'UAI$_PWD_LENGTH'
    ,'UAI$_PWD_LIFETIME'     ,'UAI$_QUEPRI'
    ,'UAI$_REMOTE_ACCESS_P'  ,'UAI$_REMOTE_ACCESS_S'
    ,'UAI$_SALT'             ,'UAI$_SHRFILLM'
    ,'UAI$_TQCNT'            ,'UAI$_UIC'
    ,'UAI$_USERNAME'         ,'UAI$_USER_DATA'
    ,'UAI$_WSEXTENT'         ,'UAI$_WSQUOTA'
    ))
# -while

---------- */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_GETUAI.C */
