/* VMS_SYS_INIT_VOL.C -- 22-JAN-1999 Uwe Zessin
   Python interface to SYS$INIT_VOL()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for INIT$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$INITDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_init_vol__doc[] =
"dict = vms_sys.init_vol (devnam, volnam [,itmlst])\n\
Initialize Volume.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_init_vol (PyObject *self, PyObject *args)
{
	char			* at_devnam;
	struct dsc$descriptor_s   r_devnam;
	unsigned long		  l_devnam_len;

	char			* at_volnam;
	struct dsc$descriptor_s   r_volnam;
	unsigned long		  l_volnam_len;

	/* item-list - tuple of tuples:                    */
	/*  ( ('INIT$_name',data), ('INIT$_name',data), ...) */
	PyObject		* ar_py_item_list;

	PyObject		* ar_arg5;
	PyObject		* ar_arg6;
	PyObject		* ar_arg7;

	/* item tuple - ('INIT$_name',data) */
	PyObject		* ar_py_item_tuple;	/* item tuple */

	/* VMS item-list to be passed to SYS$INIT_VOL() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into "   */

	/* -------------------- */
	ar_py_item_list = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#s#|O",
	    &at_devnam, &l_devnam_len,
	    &at_volnam, &l_volnam_len,
	    &ar_py_item_list ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: devnam */
	if (l_devnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: devnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_devnam.dsc$w_length  = l_devnam_len;
	r_devnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_devnam.dsc$b_class   = DSC$K_CLASS_S;
	r_devnam.dsc$a_pointer = at_devnam;

	/* -------------------- */
	/* argument 2: volnam */
	if (l_volnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: volnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_volnam.dsc$w_length  = l_volnam_len;
	r_volnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_volnam.dsc$b_class   = DSC$K_CLASS_S;
	r_volnam.dsc$a_pointer = at_volnam;

	/* -------------------- */
	/* argument 3: itmlst */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist = 0;
	}
	else
	{
	  PyObject * ar_xxx;

	  if (!PyTuple_Check(ar_py_item_list))
	  {
	    PyErr_SetString(PyExc_TypeError,
		"argument 3: itmlst - must be tuple of tuples");
	    return NULL;
	  }

	  /* SYS$INIT_VOL currently (V6.1) does not have any output-items */
	  ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP |
		 ITMTBL_M_INITVOL_SYMITM	/* input-item bit    */
		,0 /* ITMTBL_M_ITMOUT */	/* output-item bit   */
		,&VMSDEF_GR_$INITDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	  if (ar_xxx == NULL)
	  {
		return NULL;		/* item list build failed */
	  }
	} /* (ar_py_item_list != Py_None) */

	/* -------------------- */
	l_status = sys$init_vol
		(&r_devnam
		,&r_volnam
		,ar_itemlist
		);

	/* -------------------- */
	/* create a dictionary to return a varying number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	  if (ar_itemlist != 0)
	  {
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	  }
	  return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	  if (ar_itemlist != 0)
	  {
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	  }
	  Py_DECREF(ar_dict);
	  return NULL;
	}
	PyDict_SetItemString(ar_dict, "status", ar_dictobj); /* @@ERRCHK */
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* currently, on OpenVMS VAX V6.1, there are no output-item */
	/* -------------------- */

	/* -------------------- */
	if (ar_itemlist != 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_init_vol () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_INIT_VOL.C */
