/* VMS_SYS_MOUNT.C -- 14-JAN-1999 Uwe Zessin
   Python interface to SYS$MOUNT()
*/


#include "python.h"
#include "vmsdef.h"

#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for MNT$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$MNTDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_mount__doc[] =
"dict = vms_sys.mount (itmlst)\n\
Mount Volume.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_mount (PyObject *self, PyObject *args)
{
	/* item-list - tuples of tuples = (('LNM$_name',data), ...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to LIB$SET_LOGICAL() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	PyObject		*  ar_dict;	/* dictionary to be returned */
	PyObject		*  ar_dictobj;	/* temp. for insert into " */

	unsigned long		  l_status;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "O", &ar_py_item_list))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: itmlst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: itmlst - must be tuple of tuples");
	    return NULL;
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$MNTDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	l_status = sys$mount (ar_itemlist);

	/* -------------------- */
	/* create a dictionary because the user might have specified an */
	/*  output-item in the item-list */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) != 0)
	{
	    Py_DECREF(ar_dictobj);
	    Py_DECREF(ar_dict);		/* drop dictionary */
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* currently (V6.1) there are no output-items */

	/* -------------------- */
	if (ar_py_item_list != Py_None)
	{
	  /* free item-list *and* all malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* done, return to Python with the dictionary */
	return ar_dict;
} /* vms_sys_mount () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_MOUNT.C */
