/* VMS_SYS_PARSE_ACL.C -- 29-JUN-1999 Uwe Zessin
   Python interface to SYS$PARSE_ACL()
*/

#include "python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

#include <descrip.h>		/* DSC$_name	 */
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_parse_acl__doc[] =
"status, errpos, aclent = vms_sys.parse_acl (aclstr ,[accnam] ,[nullarg])\n\
Parse Access Control List Entry.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_parse_acl (PyObject *self, PyObject *args)
{
	char			* at_aclstr;
	struct dsc$descriptor_s   r_aclstr;
	unsigned long		  l_aclstr_len;

	PyObject		* ar_accnam;
	long			* aq_access_names;

	PyObject		* ar_nullarg;

	unsigned char		* at_aclent;
	struct dsc$descriptor_s   r_aclent;
	unsigned short int	  w_errpos;

	PyObject		* ar_return;	/* output */

	unsigned long		  l_status;

	/* -------------------- */
	ar_accnam  = Py_None;
	ar_nullarg = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|OO",
	    &at_aclstr, &l_aclstr_len,
	    &ar_accnam,
	    &ar_nullarg ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: aclstr */
	if (l_aclstr_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 1: aclstr - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up descriptor */
	r_aclstr.dsc$w_length  = l_aclstr_len;
	r_aclstr.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_aclstr.dsc$b_class   = DSC$K_CLASS_S;
	r_aclstr.dsc$a_pointer = at_aclstr;

	/* -------------------- */
	/* argument 2: accnam */
	if (ar_accnam == Py_None)
	{
	    aq_access_names = 0;	/* omitted */
	}
	else
	{
	    if (! vmsobj__access_names_Check(ar_accnam))
	    {
		PyErr_SetString(PyExc_TypeError,
		  "argument 2: accnam - must be vmsobj__access_names or None");
		return NULL;
	    }
	    aq_access_names =
			((vmsobj__access_names *) ar_accnam)->aq_access_names;
	}

	/* -------------------- */
	/* argument 3: nullarg */
	if (ar_nullarg != Py_None)
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 3: nullarg - must be None or omitted");
	    return NULL;
	}

	/* -------------------- */
	/* allocate memory for 'aclent' */
#define S_ACLENT 256	/* only one ACE is processed */
	at_aclent = malloc (S_ACLENT);
	if (at_aclent == NULL)
	{
	    PyErr_NoMemory();
	    return NULL;
	}
	/* zero ACE buffer */
	(void) memset (at_aclent, 0, S_ACLENT);

	/* set up descriptor */
	r_aclent.dsc$w_length  = S_ACLENT;
	r_aclent.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_aclent.dsc$b_class   = DSC$K_CLASS_S;
	r_aclent.dsc$a_pointer = (char *)at_aclent;

	/* -------------------- */
	l_status = sys$parse_acl
			(&r_aclstr
			,&r_aclent
			,&w_errpos
			,aq_access_names
			,0		/* [nullarg] */
			);

	/* -------------------- */
	/* return ACL string */
	ar_return = Py_BuildValue ("lls#", l_status,
				(unsigned int)w_errpos,
				at_aclent, (unsigned int)*at_aclent);
				/* 1st byte of ACE is length --^ */

	(void) free (at_aclent);

	return ar_return;

} /* vms_sys_parse_acl () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_PARSE_ACL.C */
